/*
 * Decompiled with CFR 0.152.
 */
package ghidra.trace.util;

import ghidra.util.datastruct.AbstractWeakValueMap;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;

public interface CopyOnWrite {

    public static class WeakHashCowSet<E>
    extends WeakAbstractCowSet<E> {
        @Override
        protected WeakValueAbstractCowMap<Integer, E> newWeakValueCowMap() {
            return new WeakValueHashCowMap();
        }
    }

    public static abstract class WeakAbstractCowSet<E>
    extends AbstractSet<E> {
        private final WeakValueAbstractCowMap<Integer, E> map = this.newWeakValueCowMap();

        protected abstract WeakValueAbstractCowMap<Integer, E> newWeakValueCowMap();

        @Override
        public Iterator<E> iterator() {
            return this.map.values().iterator();
        }

        @Override
        public int size() {
            return this.map.size();
        }

        @Override
        public boolean isEmpty() {
            return this.map.isEmpty();
        }

        @Override
        public boolean contains(Object o) {
            return this.map.get(System.identityHashCode(o)) == o;
        }

        @Override
        public boolean add(E e) {
            return this.map.put(System.identityHashCode(e), e) != e;
        }

        @Override
        public boolean remove(Object o) {
            return this.map.remove(System.identityHashCode(o)) == o;
        }

        @Override
        public void clear() {
            this.map.clear();
        }

        @Override
        public Object[] toArray() {
            return this.map.values().toArray();
        }

        @Override
        public <T> T[] toArray(T[] a) {
            return this.map.values().toArray(a);
        }
    }

    public static class WeakValueHashCowMap<K, V>
    extends WeakValueAbstractCowMap<K, V> {
        @Override
        protected AbstractCowMap<K, AbstractWeakValueMap.WeakValueRef<K, V>> newCowMap() {
            return new HashCowMap();
        }
    }

    public static abstract class WeakValueAbstractCowMap<K, V>
    extends AbstractWeakValueMap<K, V> {
        private final AbstractCowMap<K, AbstractWeakValueMap.WeakValueRef<K, V>> refMap = this.newCowMap();

        protected abstract AbstractCowMap<K, AbstractWeakValueMap.WeakValueRef<K, V>> newCowMap();

        protected Map<K, AbstractWeakValueMap.WeakValueRef<K, V>> getRefMap() {
            return this.refMap;
        }
    }

    public static class HashCowMap<K, V>
    extends AbstractCowMap<K, V> {
        @Override
        protected Map<K, V> copyMap(Map<K, V> map) {
            return new HashMap<K, V>(map);
        }
    }

    public static abstract class AbstractCowMap<K, V>
    implements Map<K, V> {
        private final AtomicReference<Map<K, V>> map = new AtomicReference(this.copyMap(Map.of()));

        protected abstract Map<K, V> copyMap(Map<K, V> var1);

        @Override
        public int size() {
            return this.map.get().size();
        }

        @Override
        public boolean isEmpty() {
            return this.map.get().isEmpty();
        }

        @Override
        public boolean containsKey(Object key) {
            return this.map.get().containsKey(key);
        }

        @Override
        public boolean containsValue(Object value) {
            return this.map.get().containsValue(value);
        }

        @Override
        public V get(Object key) {
            return this.map.get().get(key);
        }

        @Override
        public V put(K key, V value) {
            return this.map.getAndUpdate(m -> {
                Map<Object, Object> withPut = this.copyMap((Map<K, V>)m);
                withPut.put(key, value);
                return withPut;
            }).get(key);
        }

        @Override
        public V remove(Object key) {
            return this.map.getAndUpdate(m -> {
                Map<K, V> withRemove = this.copyMap((Map<K, V>)m);
                withRemove.remove(key);
                return withRemove;
            }).get(key);
        }

        @Override
        public void putAll(Map<? extends K, ? extends V> from) {
            this.map.getAndUpdate(m -> {
                Map<K, V> withPutAll = this.copyMap((Map<K, V>)m);
                withPutAll.putAll(from);
                return withPutAll;
            });
        }

        @Override
        public void clear() {
            this.map.set(this.copyMap(Map.of()));
        }

        @Override
        public Set<K> keySet() {
            return Collections.unmodifiableSet(this.map.get().keySet());
        }

        @Override
        public Collection<V> values() {
            return Collections.unmodifiableCollection(this.map.get().values());
        }

        @Override
        public Set<Map.Entry<K, V>> entrySet() {
            return Collections.unmodifiableSet(this.map.get().entrySet());
        }

        @Override
        public V computeIfAbsent(K key, Function<? super K, ? extends V> mappingFunction) {
            return this.map.getAndUpdate(m -> {
                if (m.containsKey(key)) {
                    return m;
                }
                Map withComputeIfAbsent = this.copyMap((Map<K, V>)m);
                withComputeIfAbsent.put(key, mappingFunction.apply((K)key));
                return withComputeIfAbsent;
            }).get(key);
        }
    }
}

