/*
 * Decompiled with CFR 0.152.
 */
package ghidra.feature.vt.gui.wizard.add;

import ghidra.feature.vt.gui.wizard.add.AddToSessionData;
import ghidra.feature.vt.gui.wizard.add.ChooseAddressSetEditorPanel;
import ghidra.framework.plugintool.PluginTool;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.listing.Program;
import java.awt.GridLayout;
import javax.swing.JPanel;

public class LimitAddressSetsPanel
extends JPanel {
    private ChooseAddressSetEditorPanel sourcePanel;
    private ChooseAddressSetEditorPanel destinationPanel;
    private PluginTool tool;

    public LimitAddressSetsPanel(PluginTool tool) {
        this.tool = tool;
        this.setLayout(new GridLayout());
    }

    public void initialize(AddToSessionData data) {
        this.removeAll();
        this.sourcePanel = this.buildSourcePanel(data);
        this.destinationPanel = this.buildDestinationPanel(data);
        this.add(this.sourcePanel);
        this.add(this.destinationPanel);
    }

    private ChooseAddressSetEditorPanel buildSourcePanel(AddToSessionData data) {
        Program program = data.getSourceProgram();
        AddressSetView selection = data.getSourceSelection();
        AddressSetView set = data.getCustomSourceAddressSet();
        AddToSessionData.AddressSetChoice choice = data.getSourceAddressSetChoice();
        return new ChooseAddressSetEditorPanel(this.tool, "Source", program, selection, set, choice);
    }

    private ChooseAddressSetEditorPanel buildDestinationPanel(AddToSessionData data) {
        Program program = data.getDestinationProgram();
        AddressSetView selection = data.getDestinationSelection();
        AddressSetView set = data.getCustomDestinationAddressSet();
        AddToSessionData.AddressSetChoice choice = data.getDestinationAddressSetChoice();
        return new ChooseAddressSetEditorPanel(this.tool, "Destination", program, selection, set, choice);
    }

    public void apply(AddToSessionData data) {
        AddToSessionData.AddressSetChoice sourceChoice = this.sourcePanel.getAddressSetChoice();
        AddToSessionData.AddressSetChoice destinationChoice = this.destinationPanel.getAddressSetChoice();
        data.setSourceAddressSetChoice(sourceChoice);
        data.setDestinationAddressSetChoice(destinationChoice);
        data.setCustomSourceAddressSet(null);
        data.setCustomDestinationAddressSet(null);
        if (sourceChoice == AddToSessionData.AddressSetChoice.MANUALLY_DEFINED) {
            data.setCustomSourceAddressSet(this.sourcePanel.getAddressSetView());
        }
        if (destinationChoice == AddToSessionData.AddressSetChoice.MANUALLY_DEFINED) {
            data.setCustomDestinationAddressSet(this.destinationPanel.getAddressSetView());
        }
    }
}

