/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.golang;

import ghidra.app.util.bin.format.golang.GoVer;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public record GoVerRange(GoVer start, GoVer end) {
    public static final GoVerRange ALL = new GoVerRange(GoVer.ANY, GoVer.ANY);
    public static final GoVerRange EMPTY = new GoVerRange(GoVer.INVALID, GoVer.INVALID);

    public static GoVerRange parse(String s) {
        GoVer start;
        String[] verNums = s.split("[+-]", -1);
        String startStr = verNums[0];
        String endStr = verNums.length > 1 ? verNums[1] : verNums[0];
        GoVer goVer = start = startStr.isBlank() ? GoVer.ANY : GoVer.parseWildcardPatch(startStr);
        GoVer end = endStr == startStr ? start : (endStr.isBlank() ? GoVer.ANY : GoVer.parseWildcardPatch(endStr));
        return start == GoVer.ANY && end == GoVer.ANY || start.isInvalid() || end.isInvalid() ? EMPTY : new GoVerRange(start, end);
    }

    public boolean isEmpty() {
        return this.start.isInvalid() || this.end.isInvalid();
    }

    public boolean hasWildcard() {
        return this.start.isWildcard() || this.end.isWildcard();
    }

    public boolean contains(GoVer ver) {
        return !(this.start.isInvalid() || this.end.isInvalid() || !this.start.isWildcard() && this.start.compareTo(ver) > 0 || !this.end.isWildcard() && this.end.compareTo(ver) < 0);
    }

    public List<GoVer> asList() throws IOException {
        if (this.start.major() != this.end.major() || this.isEmpty() || this.hasWildcard()) {
            throw new IOException("Unable to make version list, invalid or wildcard or spans versions");
        }
        ArrayList<GoVer> result = new ArrayList<GoVer>();
        GoVer current = this.start;
        for (int minor = current.getMinor(); minor <= this.end.minor(); ++minor) {
            result.add(new GoVer(1, minor, 0));
        }
        return result;
    }
}

