/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.exceptionhandlers.gcc.sections;

import ghidra.app.cmd.comments.SetCommentCmd;
import ghidra.app.cmd.data.CreateArrayCmd;
import ghidra.app.plugin.exceptionhandlers.gcc.RegionDescriptor;
import ghidra.app.plugin.exceptionhandlers.gcc.sections.CieSource;
import ghidra.app.plugin.exceptionhandlers.gcc.structures.ehFrame.Cie;
import ghidra.app.plugin.exceptionhandlers.gcc.structures.ehFrame.ExceptionHandlerFrameException;
import ghidra.app.plugin.exceptionhandlers.gcc.structures.ehFrame.FrameDescriptionEntry;
import ghidra.program.model.address.Address;
import ghidra.program.model.data.ByteDataType;
import ghidra.program.model.data.DataType;
import ghidra.program.model.listing.CommentType;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.MemoryAccessException;
import ghidra.program.model.mem.MemoryBlock;
import ghidra.program.model.symbol.SourceType;
import ghidra.program.model.symbol.Symbol;
import ghidra.util.Msg;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.exception.InvalidInputException;
import ghidra.util.task.TaskMonitor;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

abstract class AbstractFrameSection
implements CieSource {
    protected TaskMonitor monitor;
    protected Program program;
    private Map<Address, Cie> cieMap = new HashMap<Address, Cie>();

    AbstractFrameSection(TaskMonitor monitor, Program program) {
        this.monitor = monitor;
        this.program = program;
    }

    protected void createAugmentationData(List<RegionDescriptor> regions, Cie cie) {
        for (RegionDescriptor region : regions) {
            FrameDescriptionEntry frame = region.getFrameDescriptorEntry();
            Address augDataExAddr = frame.getAugmentationExDataAddress();
            if (augDataExAddr.equals((Object)Address.NO_ADDRESS)) continue;
            Address addr = augDataExAddr;
            MemoryBlock block = this.program.getMemory().getBlock(augDataExAddr);
            int len = 0;
            int alignment = cie.getCodeAlignment();
            do {
                len += alignment;
                addr = addr.add((long)alignment);
            } while (this.program.getSymbolTable().getPrimarySymbol(addr) == null && block.contains(addr));
            if (len <= 0) continue;
            CreateArrayCmd arrayCmd = new CreateArrayCmd(augDataExAddr, len, (DataType)new ByteDataType(), 1);
            arrayCmd.applyTo(this.program);
        }
    }

    protected Cie createCie(Address curAddress, boolean isInDebugFrame) throws MemoryAccessException, ExceptionHandlerFrameException {
        Cie cie = new Cie(this.monitor, this.program, isInDebugFrame);
        cie.create(curAddress);
        if (cie.isEndOfFrame()) {
            return cie;
        }
        this.createCieLabel(curAddress);
        this.createCieComment(curAddress);
        return cie;
    }

    protected Cie getCieOrCreateIfMissing(Address curAddress, boolean isInDebugFrame) throws MemoryAccessException, ExceptionHandlerFrameException {
        Cie cie = this.cieMap.get(curAddress);
        if (cie == null) {
            cie = this.createCie(curAddress, isInDebugFrame);
            this.cieMap.put(curAddress, cie);
        }
        return cie;
    }

    protected void createCieLabel(Address curAddress) {
        try {
            String cieLabel = "cie_" + curAddress.toString();
            Symbol cieSym = this.program.getSymbolTable().getPrimarySymbol(curAddress);
            if (cieSym == null) {
                cieSym = this.program.getSymbolTable().createLabel(curAddress, cieLabel, SourceType.ANALYSIS);
            } else {
                cieSym.setName(cieLabel, SourceType.ANALYSIS);
            }
        }
        catch (DuplicateNameException | InvalidInputException e) {
            Msg.info((Object)this, (Object)("Unable to label CIE -- " + e.getMessage()), (Throwable)e);
        }
    }

    protected void createCieComment(Address curAddress) {
        this.createPlateComment(curAddress, "Common Information Entry");
    }

    protected void createFdeComment(Address curAddress) {
        this.createPlateComment(curAddress, "Frame Descriptor Entry");
    }

    private void createPlateComment(Address curAddress, String fdeComment) {
        SetCommentCmd commentCmd = new SetCommentCmd(curAddress, CommentType.PLATE, fdeComment);
        commentCmd.applyTo(this.program);
    }
}

