/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.database.module;

import db.DBHandle;
import db.DBRecord;
import db.Field;
import db.RecordIterator;
import db.RecordTranslator;
import db.StringField;
import db.Table;
import db.TranslatedRecordIterator;
import ghidra.program.database.module.ModuleDBAdapter;
import ghidra.program.database.module.ModuleDBAdapterV1;
import ghidra.program.database.module.ParentChildDBAdapter;
import ghidra.util.exception.AssertException;
import ghidra.util.exception.VersionException;
import java.io.IOException;

class ModuleDBAdapterV0
extends ModuleDBAdapter
implements RecordTranslator {
    static final int V0_VERSION = 0;
    static final int V0_MODULE_NAME_COL = 0;
    static final int V0_MODULE_COMMENTS_COL = 1;
    private Table moduleTable;
    private ParentChildDBAdapter parentChildAdapter;

    public ModuleDBAdapterV0(DBHandle handle, long treeID, ParentChildDBAdapter parentChildAdapter) throws VersionException, IOException {
        this.parentChildAdapter = parentChildAdapter;
        String tableName = ModuleDBAdapterV0.getTableName(treeID);
        this.moduleTable = handle.getTable(tableName);
        if (this.moduleTable == null) {
            throw new VersionException("Missing Table: " + tableName);
        }
        int version = this.moduleTable.getSchema().getVersion();
        if (version != 0) {
            throw new VersionException(2, false);
        }
    }

    @Override
    public DBRecord createModuleRecord(long parentModuleID, String name) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    DBRecord getModuleRecord(long key) throws IOException {
        return this.translateRecord(this.moduleTable.getRecord(key));
    }

    @Override
    DBRecord getModuleRecord(String name) throws IOException {
        Field[] keys = this.moduleTable.findRecords((Field)new StringField(name), 0);
        if (keys.length == 0) {
            return null;
        }
        if (keys.length > 1) {
            throw new AssertException("Found " + keys.length + " modules named " + name);
        }
        return this.translateRecord(this.moduleTable.getRecord(keys[0]));
    }

    @Override
    RecordIterator getRecords() throws IOException {
        return new TranslatedRecordIterator(this.moduleTable.iterator(), (RecordTranslator)this);
    }

    @Override
    void updateModuleRecord(DBRecord record) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    boolean removeModuleRecord(long childID) throws IOException {
        throw new UnsupportedOperationException();
    }

    public DBRecord translateRecord(DBRecord oldRec) throws IOException {
        if (oldRec == null) {
            return null;
        }
        DBRecord rec = ModuleDBAdapterV1.V1_MODULE_SCHEMA.createRecord(oldRec.getKey());
        rec.setString(0, oldRec.getString(0));
        rec.setString(1, oldRec.getString(1));
        Field[] keys = this.parentChildAdapter.getParentChildKeys(rec.getKey(), 0);
        rec.setIntValue(2, keys.length);
        return rec;
    }
}

