/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.database;

import db.DBRecord;
import ghidra.program.database.DBObjectCache;
import ghidra.util.Lock;
import java.util.ConcurrentModificationException;

public abstract class DatabaseObject {
    protected long key;
    private volatile boolean deleted;
    private final DBObjectCache cache;
    private volatile int invalidateCount;
    private boolean refreshing = false;

    protected DatabaseObject(DBObjectCache cache, long key) {
        this.key = key;
        this.cache = cache;
        if (cache != null) {
            cache.put(this);
            this.invalidateCount = cache.getInvalidateCount();
        }
    }

    public long getKey() {
        return this.key;
    }

    protected void setDeleted() {
        this.deleted = true;
    }

    public void setInvalid() {
        this.invalidateCount = this.getCurrentValidationCount() - 1;
    }

    private void setValid() {
        this.invalidateCount = this.getCurrentValidationCount();
    }

    private int getCurrentValidationCount() {
        return this.cache != null ? this.cache.getInvalidateCount() : 0;
    }

    protected void keyChanged(long newKey) {
        long oldKey = this.key;
        this.key = newKey;
        if (this.cache != null) {
            this.cache.keyChanged(oldKey, this.key);
        }
    }

    protected boolean isInvalid() {
        return !this.deleted && this.invalidateCount != this.getCurrentValidationCount();
    }

    protected void checkDeleted() {
        if (!this.checkIsValid()) {
            throw new ConcurrentModificationException("Object has been deleted.");
        }
    }

    protected boolean checkIsValid() {
        return this.checkIsValid(null);
    }

    protected boolean checkIsValid(DBRecord record) {
        if (this.isInvalid()) {
            if (this.refreshing) {
                return !this.deleted;
            }
            this.refreshing = true;
            try {
                if (this.refresh(record)) {
                    this.setValid();
                    boolean bl = true;
                    return bl;
                }
                if (this.cache != null) {
                    this.cache.delete(this.key);
                }
                this.setDeleted();
                boolean bl = false;
                return bl;
            }
            finally {
                this.refreshing = false;
            }
        }
        return !this.deleted;
    }

    protected boolean validate(Lock lock) {
        if (!this.isInvalid()) {
            return !this.deleted;
        }
        lock.acquire();
        try {
            boolean bl = this.checkIsValid();
            return bl;
        }
        finally {
            lock.release();
        }
    }

    public boolean isDeleted(Lock lock) {
        return this.deleted || !this.validate(lock);
    }

    protected abstract boolean refresh();

    protected boolean refresh(DBRecord record) {
        return this.refresh();
    }
}

