/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.dom;

import io.sf.carte.doc.dom.AbstractDOMNode;
import io.sf.carte.doc.dom.DOMElement;
import io.sf.carte.doc.style.css.MediaQueryList;
import io.sf.carte.doc.style.css.om.AbstractCSSStyleSheet;

class StyleDefinerElementHelper {
    private final DOMElement element;
    private AbstractCSSStyleSheet definedSheet = null;
    private boolean needsUpdate = true;

    StyleDefinerElementHelper(DOMElement element) {
        this.element = element;
    }

    AbstractCSSStyleSheet getInlineSheet() {
        if (this.needsUpdate) {
            String type = this.element.getAttribute("type");
            if (!"text/css".equalsIgnoreCase(type) && type.length() != 0) {
                return null;
            }
            MediaQueryList mediaList = this.element.getOwnerDocument().parseMediaList(this.element.getAttribute("media").trim(), this.element);
            if (mediaList == null) {
                return null;
            }
            String title = this.element.getAttribute("title").trim();
            if (title.length() == 0) {
                title = null;
            }
            String styleText = this.element.getTextContent().trim();
            this.definedSheet = this.element.getOwnerDocument().parseEmbeddedStyleSheet(this.definedSheet, styleText, title, mediaList, this.element);
            this.needsUpdate = false;
        }
        return this.definedSheet;
    }

    AbstractCSSStyleSheet getLinkedSheet() {
        if (this.needsUpdate) {
            String rel = this.element.getAttribute("rel");
            String type = this.element.getAttribute("type");
            int typelen = type.length();
            if (typelen == 0 ? rel.length() == 0 : !"text/css".equalsIgnoreCase(type)) {
                return null;
            }
            byte relAttr = AbstractCSSStyleSheet.parseRelAttribute(rel);
            if (relAttr != -1) {
                String href;
                String title = this.element.getAttribute("title").trim();
                if (title.length() == 0) {
                    title = null;
                }
                if ((href = this.element.getAttribute("href")).length() != 0) {
                    if (relAttr == 0) {
                        if (this.loadLinkedStyleSheet(href, title)) {
                            this.needsUpdate = false;
                        }
                    } else if (title != null) {
                        if (href.length() != 0) {
                            boolean disable;
                            boolean bl = disable = this.definedSheet == null || !title.equalsIgnoreCase(this.element.getOwnerDocument().getSelectedStyleSheetSet());
                            if (this.loadLinkedStyleSheet(href, title)) {
                                if (disable) {
                                    this.definedSheet.setDisabled(true);
                                }
                                this.needsUpdate = false;
                            }
                        }
                    } else {
                        this.element.getOwnerDocument().getErrorHandler().linkedStyleError(this.element, "Alternate sheet without title");
                    }
                } else {
                    this.element.getOwnerDocument().getErrorHandler().linkedStyleError(this.element, "Missing or void href attribute.");
                }
            } else {
                this.definedSheet = null;
            }
        }
        return this.definedSheet;
    }

    private boolean loadLinkedStyleSheet(String href, String title) {
        MediaQueryList media = this.element.getOwnerDocument().parseMediaList(this.element.getAttribute("media").trim(), this.element);
        if (media == null) {
            this.definedSheet = null;
            return false;
        }
        this.definedSheet = this.element.getOwnerDocument().loadStyleSheet(this.definedSheet, href, title, media, this.element);
        return true;
    }

    void resetSheet() {
        AbstractCSSStyleSheet sheet = this.definedSheet;
        if (sheet != null) {
            sheet.getCssRules().clear();
        }
        this.needsUpdate = true;
        this.element.getOwnerDocument().onSheetModify();
    }

    void postAddChildInline(AbstractDOMNode newChild) {
        if (this.element.getFirstChild().getNextSibling() != null) {
            this.resetSheet();
            this.getInlineSheet();
        }
    }

    boolean containsCSS() {
        AbstractCSSStyleSheet sheet;
        String type;
        return this.definedSheet != null && ("text/css".equalsIgnoreCase(type = this.element.getAttribute("type")) || type.length() == 0 && (sheet = this.getInlineSheet()) != null && sheet.getCssRules().getLength() != 0);
    }
}

