# F:=Rationals();
local result, l;
result:= rec();
result.comment:=
"2a\"M20 = 2^5:A5 as 6 x 6 monomial matrices over Z.\n\
Representation 6a.\n\
Absolutely irreducible representation.\n\
Schur Index 1.\n\
\n\
SEED:\n\
Nonzero v fixed by x and y*x*y^-1 where <x,y*x*y^-1> = 2^4:D10.\n\
v has 2 x 6 = 12 images under G; <v> has 6 images under G.\n\
BASIS:\n\
NSB([y,x]) with above v.\n\
\n\
Possible matrix entries are in {-1,0,1}.\n\
\n\
Average number of nonzero entries for any element of the group:\n\
6  (about 16.667%).\n\
\n\
Entry  Av/Mat           %Av/Mat\n\
    0     30     83.333 [83+1/3]\n\
   1      6     16.667 [16+2/3]\n\
    1      3      8.333 [ 8+1/3]\n\
   -1      3      8.333 [ 8+1/3]\n\
";
result.symmetricforms:= [];
result.antisymmetricforms:= [];
result.hermitianforms:= [];
result.centralizeralgebra:= [];
result.generators:= List( [ [
1,0,0,0,0,0,
0,1,0,0,0,0,
0,0,0,1,0,0,
0,0,-1,0,0,0,
0,0,0,0,0,-1,
0,0,0,0,1,0]
,[
0,1,0,0,0,0,
0,0,1,0,0,0,
1,0,0,0,0,0,
0,0,0,0,1,0,
0,0,0,0,0,1,
0,0,0,1,0,0]
], l -> List( [ 0 .. 5 ],
i -> l{ [ i*6+1 .. (i+1)*6 ] } ) );


Add( result.symmetricforms, IdentityMat(6) );


Add( result.centralizeralgebra, IdentityMat(6) );
return result;
