/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.mode;

import java.awt.event.ActionEvent;
import javax.swing.JComponent;
import javax.swing.JRootPane;
import javax.swing.SwingUtilities;
import org.freeplane.core.resources.ResourceController;
import org.freeplane.core.ui.AFreeplaneAction;
import org.freeplane.features.map.IMapSelection;
import org.freeplane.features.mode.Controller;

class MoveSelectedNodeAction
extends AFreeplaneAction {
    private static final String MOVE_SLOWLY_PROPERTY = "slow_scroll_selected_node";
    private static final long serialVersionUID = 1L;
    private final IMapSelection.NodePosition nodePosition;

    public MoveSelectedNodeAction(IMapSelection.NodePosition nodePosition) {
        super("MoveSelectedNodeAction." + nodePosition.name());
        this.nodePosition = nodePosition;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        IMapSelection selection = Controller.getCurrentController().getSelection();
        JComponent mapView = Controller.getCurrentController().getMapViewManager().getMapViewComponent();
        JRootPane rootPane = SwingUtilities.getRootPane(mapView);
        if (!rootPane.isValid()) {
            rootPane.revalidate();
        }
        if (ResourceController.getResourceController().getBooleanProperty(MOVE_SLOWLY_PROPERTY)) {
            selection.slowlyMoveNodeTo(selection.getSelected(), this.nodePosition);
        } else {
            selection.moveNodeTo(selection.getSelected(), this.nodePosition);
        }
    }
}

