/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.navigator.dialogs;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.services.IServiceLocator;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.exec.DBCExecutionContextDefaults;
import org.jkiss.dbeaver.model.navigator.DBNDatabaseNode;
import org.jkiss.dbeaver.model.navigator.DBNUtils;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.DBRRunnableWithResult;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSObjectContainer;
import org.jkiss.dbeaver.model.struct.rdb.DBSCatalog;
import org.jkiss.dbeaver.model.struct.rdb.DBSSchema;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.ActionUtils;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.internal.UIMessages;
import org.jkiss.dbeaver.ui.navigator.dialogs.ObjectListDialog;
import org.jkiss.dbeaver.ui.navigator.itemlist.DatabaseObjectListControl;
import org.jkiss.utils.CommonUtils;

public class SelectDatabaseDialog
extends ObjectListDialog<DBNDatabaseNode> {
    private static final Log log = Log.getLog(SelectDatabaseDialog.class);
    private final DBPDataSourceContainer dataSourceContainer;
    private volatile String currentInstanceName;
    private final List<DBNDatabaseNode> selectedInstances = new ArrayList<DBNDatabaseNode>();

    public SelectDatabaseDialog(@NotNull Shell parentShell, @NotNull DBPDataSourceContainer dataSourceContainer, @Nullable String currentInstanceName, @NotNull Collection<DBNDatabaseNode> objects, @NotNull Collection<DBNDatabaseNode> selected) {
        super(parentShell, NLS.bind((String)UIMessages.label_choose, (Object)UIUtils.getCatalogSchemaTerms((DBPDataSourceContainer)dataSourceContainer, (boolean)true)), true, "SchemaSelector", objects, selected);
        this.dataSourceContainer = dataSourceContainer;
        this.currentInstanceName = currentInstanceName;
    }

    @Override
    protected void createUpperControls(@NotNull Composite dialogArea) {
        DBPDataSource dataSource = this.dataSourceContainer.getDataSource();
        if (this.currentInstanceName == null || dataSource == null) {
            return;
        }
        DBCExecutionContextDefaults<?, ?> contextDefaults = this.getContextDefaults();
        if (contextDefaults != null && contextDefaults.supportsCatalogChange() && contextDefaults.supportsSchemaChange()) {
            DBSObjectContainer instanceContainer = (DBSObjectContainer)DBUtils.getAdapter(DBSObjectContainer.class, (Object)dataSource);
            if (instanceContainer == null) {
                UIUtils.showMessageBox((Shell)this.getShell(), (String)"No database objects were found", (String)("No database objects were found. Please set active datasource (" + ActionUtils.findCommandDescription((String)"org.jkiss.dbeaver.ui.tools.select.connection", (IServiceLocator)UIUtils.getActiveWorkbenchWindow(), (boolean)true) + ") for this editor."), (int)1);
                return;
            }
            this.createInstanceSelector(dialogArea, instanceContainer);
        }
    }

    @Override
    protected void handleObjectsLoaded(Collection<DBNDatabaseNode> items, boolean append) {
        if (this.selectedInstances.isEmpty()) {
            return;
        }
        ArrayList selObjects = new ArrayList();
        Collection schemas = (Collection)this.objectList.getItemsViewer().getInput();
        if (schemas != null) {
            for (Object node : schemas) {
                if (!DBNUtils.isDefaultElement(node)) continue;
                selObjects.add(node);
            }
        }
        this.objectList.getSelectionProvider().setSelection((ISelection)new StructuredSelection(selObjects));
    }

    @Nullable
    private DBCExecutionContextDefaults<?, ?> getContextDefaults() {
        DBPDataSource dataSource = this.dataSourceContainer.getDataSource();
        DBSObjectContainer instanceContainer = (DBSObjectContainer)DBUtils.getAdapter(DBSObjectContainer.class, (Object)dataSource);
        DBCExecutionContext defaultContext = DBUtils.getDefaultContext((DBSObject)instanceContainer, (boolean)true);
        if (defaultContext == null) {
            return null;
        }
        return defaultContext.getContextDefaults();
    }

    private void createInstanceSelector(Composite group, final DBSObjectContainer instanceContainer) {
        ++((GridLayout)group.getLayout()).numColumns;
        DatabaseObjectListControl<DBNDatabaseNode> instanceList = this.createObjectSelector(group, true, "DatabaseInstanceSelector", this.selectedInstances, new DBRRunnableWithResult<List<DBNDatabaseNode>>(){

            public void run(DBRProgressMonitor monitor) throws InvocationTargetException {
                try {
                    DBNDatabaseNode activeInstanceNode;
                    DBSObject activeInstance;
                    if (!CommonUtils.isEmpty((String)SelectDatabaseDialog.this.currentInstanceName) && SelectDatabaseDialog.this.selectedInstances.isEmpty() && (activeInstance = instanceContainer.getChild(monitor, SelectDatabaseDialog.this.currentInstanceName)) != null && (activeInstanceNode = DBNUtils.getNodeByObject((DBRProgressMonitor)monitor, (DBSObject)activeInstance, (boolean)false)) != null) {
                        SelectDatabaseDialog.this.selectedInstances.add(activeInstanceNode);
                    }
                    Collection instances = instanceContainer.getChildren(monitor);
                    this.result = SelectDatabaseDialog.getNodeList(monitor, instances);
                    SelectDatabaseDialog.this.objectList.loadData();
                }
                catch (DBException e) {
                    throw new InvocationTargetException(e);
                }
            }
        });
        instanceList.createProgressPanel();
        GridData gd = new GridData(1808);
        gd.heightHint = 300;
        gd.minimumWidth = 500;
        instanceList.setLayoutData(gd);
        instanceList.getSelectionProvider().addSelectionChangedListener(event -> {
            DBNDatabaseNode instance;
            IStructuredSelection selection = (IStructuredSelection)event.getSelection();
            this.selectedInstances.clear();
            this.selectedInstances.addAll(selection.toList());
            DBNDatabaseNode dBNDatabaseNode = instance = this.selectedInstances.isEmpty() ? null : this.selectedInstances.getFirst();
            if (instance != null && !CommonUtils.equalObjects((Object)instance.getNodeDisplayName(), (Object)this.currentInstanceName)) {
                this.currentInstanceName = instance.getNodeDisplayName();
                this.objectList.loadData();
            }
        });
        instanceList.setDoubleClickHandler(event -> {
            if (this.isModeless() || this.isButtonEnabled(0)) {
                this.okPressed();
            }
        });
        instanceList.loadData();
        this.closeOnFocusLost(new Control[]{instanceList.getItemsViewer().getControl()});
    }

    @Override
    protected List<DBNDatabaseNode> getObjects(@NotNull DBRProgressMonitor monitor) {
        DBNDatabaseNode instanceNode;
        Object rootObject = this.selectedInstances != null && this.currentInstanceName != null && this.getContextDefaults() != null && this.getContextDefaults().supportsSchemaChange() ? ((instanceNode = (DBNDatabaseNode)DBUtils.findObject(this.selectedInstances, (String)this.currentInstanceName)) == null ? null : instanceNode.getObject()) : this.dataSourceContainer.getDataSource();
        if (rootObject instanceof DBSObjectContainer) {
            try {
                List<DBSSchema> objectsCollection;
                DBCExecutionContextDefaults<?, ?> contextDefaults = this.getContextDefaults();
                if (rootObject instanceof DBSCatalog && contextDefaults != null && !contextDefaults.supportsSchemaChange()) {
                    DBSSchema schema = contextDefaults.getDefaultSchema();
                    objectsCollection = Collections.singletonList(schema);
                } else {
                    objectsCollection = ((DBSObjectContainer)rootObject).getChildren(monitor);
                }
                return SelectDatabaseDialog.getNodeList(monitor, (Collection<? extends DBSObject>)objectsCollection);
            }
            catch (DBException e) {
                log.error((Object)e);
                return Collections.emptyList();
            }
        }
        return this.objects;
    }

    @NotNull
    private static List<DBNDatabaseNode> getNodeList(@NotNull DBRProgressMonitor monitor, @Nullable Collection<? extends DBSObject> objectList) {
        if (CommonUtils.isEmpty(objectList)) {
            return Collections.emptyList();
        }
        int nodesLimit = DBWorkbench.getPlatform().getPreferenceStore().getInt("navigator.long.list.fetch.size");
        ArrayList<DBNDatabaseNode> nodeList = new ArrayList<DBNDatabaseNode>(objectList.size());
        for (DBSObject dBSObject : objectList) {
            DBNDatabaseNode databaseNode;
            if (!(dBSObject instanceof DBSObjectContainer) || (databaseNode = DBNUtils.getNodeByObject((DBRProgressMonitor)monitor, (DBSObject)dBSObject, (boolean)false)) == null) continue;
            nodeList.add(databaseNode);
            if (nodeList.size() >= nodesLimit) break;
        }
        return nodeList;
    }

    public String getCurrentInstanceName() {
        DBNDatabaseNode selectedObject = (DBNDatabaseNode)this.getSelectedObject();
        if (selectedObject.getObject() instanceof DBSCatalog) {
            return selectedObject.getObject().getName();
        }
        return this.currentInstanceName;
    }
}

