﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/cloudfront-keyvaluestore/CloudFrontKeyValueStoreRequest.h>
#include <aws/cloudfront-keyvaluestore/CloudFrontKeyValueStore_EXPORTS.h>
#include <aws/core/utils/memory/stl/AWSString.h>

#include <utility>

namespace Aws {
namespace CloudFrontKeyValueStore {
namespace Model {

/**
 */
class DescribeKeyValueStoreRequest : public CloudFrontKeyValueStoreRequest {
 public:
  AWS_CLOUDFRONTKEYVALUESTORE_API DescribeKeyValueStoreRequest() = default;

  // Service request name is the Operation name which will send this request out,
  // each operation should has unique request name, so that we can get operation's name from this request.
  // Note: this is not true for response, multiple operations may have the same response name,
  // so we can not get operation's name from response.
  inline virtual const char* GetServiceRequestName() const override { return "DescribeKeyValueStore"; }

  AWS_CLOUDFRONTKEYVALUESTORE_API Aws::String SerializePayload() const override;

  /**
   * Helper function to collect parameters (configurable and static hardcoded) required for endpoint computation.
   */
  AWS_CLOUDFRONTKEYVALUESTORE_API EndpointParameters GetEndpointContextParams() const override;

  ///@{
  /**
   * <p>The Amazon Resource Name (ARN) of the Key Value Store.</p>
   */
  inline const Aws::String& GetKvsARN() const { return m_kvsARN; }
  inline bool KvsARNHasBeenSet() const { return m_kvsARNHasBeenSet; }
  template <typename KvsARNT = Aws::String>
  void SetKvsARN(KvsARNT&& value) {
    m_kvsARNHasBeenSet = true;
    m_kvsARN = std::forward<KvsARNT>(value);
  }
  template <typename KvsARNT = Aws::String>
  DescribeKeyValueStoreRequest& WithKvsARN(KvsARNT&& value) {
    SetKvsARN(std::forward<KvsARNT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_kvsARN;
  bool m_kvsARNHasBeenSet = false;
};

}  // namespace Model
}  // namespace CloudFrontKeyValueStore
}  // namespace Aws
