#!/usr/bin/python
# -*- coding: utf-8 -*-
#
# Copyright (C) 2017-2025 Google
# GNU General Public License v3.0+ (see COPYING or https://www.gnu.org/licenses/gpl-3.0.txt)
# ----------------------------------------------------------------------------
#
#     ***     AUTO GENERATED CODE    ***    Type: MMv1     ***
#
# ----------------------------------------------------------------------------
#
#     This file is automatically generated by Magic Modules and manual
#     changes will be clobbered when the file is regenerated.
#
# ----------------------------------------------------------------------------
#

from __future__ import absolute_import, division, print_function

__metaclass__ = type

################################################################################
# Documentation
################################################################################

ANSIBLE_METADATA = {
    "metadata_version": "1.1",
    "status": ["preview"],
    "supported_by": "community",
}

DOCUMENTATION = r"""
---
author:
  - Google Inc. (@googlecloudplatform)
description:
  - A managed alloydb cluster.
extends_documentation_fragment:
  - google.cloud.gcp
module: gcp_alloydb_cluster
notes:
  - 'API Reference: U(https://cloud.google.com/alloydb/docs/reference/rest/v1/projects.locations.clusters/create)'
  - 'AlloyDB Guide: U(https://cloud.google.com/alloydb/docs/)'
options:
  annotations:
    description:
      - Annotations to allow client tools to store small amount of arbitrary data.
      - This is distinct from labels.
      - 'https://google.aip.dev/128 An object containing a list of "key": value pairs.'
      - 'Example: { "name": "wrench", "mass": "1.3kg", "count": "3" }.'
    type: dict
  automated_backup_policy:
    description:
      - The automated backup policy for this cluster.
      - AutomatedBackupPolicy is disabled by default.
    suboptions:
      backup_window:
        description:
          - The length of the time window during which a backup can be taken.
          - If a backup does not succeed within this time window, it will be canceled and considered failed.
          - The backup window must be at least 5 minutes long.
          - There is no upper bound on the window.
          - If not set, it will default to 1 hour.
          - A duration in seconds with up to nine fractional digits, terminated by 's'.
          - 'Example: "3.5s".'
        type: str
      enabled:
        description:
          - Whether automated backups are enabled.
        type: bool
      encryption_config:
        description:
          - EncryptionConfig describes the encryption config of a cluster or a backup that is encrypted with a CMEK (customer-managed encryption key).
        suboptions:
          kms_key_name:
            description:
              - The fully-qualified resource name of the KMS key.
              - >-
                Each Cloud KMS key is regionalized and has the following format:

                projects/[PROJECT]/locations/[REGION]/keyRings/[RING]/cryptoKeys/[KEY_NAME].
            type: str
        type: dict
      labels:
        description:
          - Labels to apply to backups created using this configuration.
        type: dict
      location:
        description:
          - The location where the backup will be stored.
          - Currently, the only supported option is to store the backup in the same region as the cluster.
        type: str
      quantity_based_retention:
        description:
          - Quantity-based Backup retention policy to retain recent backups.
          - Conflicts with 'time_based_retention', both can't be set together.
        suboptions:
          count:
            description:
              - The number of backups to retain.
            type: int
        type: dict
      time_based_retention:
        description:
          - Time-based Backup retention policy.
          - Conflicts with 'quantity_based_retention', both can't be set together.
        suboptions:
          retention_period:
            description:
              - The retention period.
              - A duration in seconds with up to nine fractional digits, terminated by 's'.
              - 'Example: "3.5s".'
            type: str
        type: dict
      weekly_schedule:
        description:
          - Weekly schedule for the Backup.
        suboptions:
          days_of_week:
            description:
              - The days of the week to perform a backup.
              - At least one day of the week must be provided.
            elements: str
            type: list
          start_times:
            description:
              - The times during the day to start a backup.
              - At least one start time must be provided.
              - The start times are assumed to be in UTC and to be an exact hour (e.g., 04:00:00).
            elements: dict
            required: true
            suboptions:
              hours:
                description:
                  - Hours of day in 24 hour format.
                  - Should be from 0 to 23.
                  - An API may choose to allow the value "24:00:00" for scenarios like business closing time.
                type: int
              minutes:
                description:
                  - Minutes of hour of day.
                  - Currently, only the value 0 is supported.
                type: int
              nanos:
                description:
                  - Fractions of seconds in nanoseconds.
                  - Currently, only the value 0 is supported.
                type: int
              seconds:
                description:
                  - Seconds of minutes of the time.
                  - Currently, only the value 0 is supported.
                type: int
            type: list
        type: dict
    type: dict
  cluster_id:
    description:
      - The ID of the alloydb cluster.
    required: true
    type: str
  cluster_type:
    choices:
      - PRIMARY
      - SECONDARY
    default: PRIMARY
    description:
      - The type of cluster.
      - If not set, defaults to PRIMARY.
    type: str
  continuous_backup_config:
    description:
      - The continuous backup config for this cluster.
      - If no policy is provided then the default policy will be used.
      - The default policy takes one backup a day and retains backups for 14 days.
    suboptions:
      enabled:
        default: true
        description:
          - Whether continuous backup recovery is enabled.
          - If not set, defaults to true.
        type: bool
      encryption_config:
        description:
          - EncryptionConfig describes the encryption config of a cluster or a backup that is encrypted with a CMEK (customer-managed encryption key).
        suboptions:
          kms_key_name:
            description:
              - The fully-qualified resource name of the KMS key.
              - >-
                Each Cloud KMS key is regionalized and has the following format:

                projects/[PROJECT]/locations/[REGION]/keyRings/[RING]/cryptoKeys/[KEY_NAME].
            type: str
        type: dict
      recovery_window_days:
        description:
          - The numbers of days that are eligible to restore from using PITR.
          - To support the entire recovery window, backups and logs are retained for one day more than the recovery window.
          - If not set, defaults to 14 days.
        type: int
    type: dict
  database_version:
    description:
      - The database engine major version.
      - This is an optional field and it's populated at the Cluster creation time.
      - 'Note: Changing this field to a higer version results in upgrading the AlloyDB cluster which is an irreversible change.'
    type: str
  display_name:
    description:
      - User-settable and human-readable display name for the Cluster.
    type: str
  encryption_config:
    description:
      - EncryptionConfig describes the encryption config of a cluster or a backup that is encrypted with a CMEK (customer-managed encryption key).
    suboptions:
      kms_key_name:
        description:
          - The fully-qualified resource name of the KMS key.
          - >-
            Each Cloud KMS key is regionalized and has the following format:

            projects/[PROJECT]/locations/[REGION]/keyRings/[RING]/cryptoKeys/[KEY_NAME].
        type: str
    type: dict
  etag:
    description:
      - For Resource freshness validation (https://google.aip.dev/154).
    type: str
  initial_user:
    description:
      - Initial user to setup during cluster creation.
    required: true
    suboptions:
      password:
        description:
          - The initial password for the user.
        required: true
        type: str
      user:
        description:
          - The database username.
        type: str
    type: dict
  labels:
    description:
      - User-defined labels for the alloydb cluster.
    type: dict
  location:
    description:
      - The location where the alloydb cluster should reside.
    required: true
    type: str
  maintenance_update_policy:
    description:
      - MaintenanceUpdatePolicy defines the policy for system updates.
    suboptions:
      maintenance_windows:
        description:
          - Preferred windows to perform maintenance.
          - Currently limited to 1.
        elements: dict
        suboptions:
          day:
            choices:
              - MONDAY
              - TUESDAY
              - WEDNESDAY
              - THURSDAY
              - FRIDAY
              - SATURDAY
              - SUNDAY
            description:
              - Preferred day of the week for maintenance, e.g.
              - MONDAY, TUESDAY, etc.
            required: true
            type: str
          start_time:
            description:
              - Preferred time to start the maintenance operation on the specified day.
              - Maintenance will start within 1 hour of this time.
            required: true
            suboptions:
              hours:
                description:
                  - Hours of day in 24 hour format.
                  - Should be from 0 to 23.
                required: true
                type: int
              minutes:
                description:
                  - Minutes of hour of day.
                  - Currently, only the value 0 is supported.
                type: int
              nanos:
                description:
                  - Fractions of seconds in nanoseconds.
                  - Currently, only the value 0 is supported.
                type: int
              seconds:
                description:
                  - Seconds of minutes of the time.
                  - Currently, only the value 0 is supported.
                type: int
            type: dict
        type: list
    type: dict
  network_config:
    description:
      - Metadata related to network configuration.
    suboptions:
      allocated_ip_range:
        description:
          - The name of the allocated IP range for the private IP AlloyDB cluster.
          - 'For example: "google-managed-services-default".'
          - If set, the instance IPs for this cluster will be created in the allocated range.
        type: str
      network:
        description:
          - The resource link for the VPC network in which cluster resources are created and from which they are accessible via Private IP.
          - The network must belong to the same project as the cluster.
          - 'It is specified in the form: "projects/{projectNumber}/global/networks/{network_id}".'
        type: str
    type: dict
  psc_config:
    description:
      - Configuration for Private Service Connect (PSC) for the cluster.
    suboptions:
      psc_enabled:
        description:
          - Create an instance that allows connections from Private Service Connect endpoints to the instance.
        type: bool
      service_owned_project_number:
        description:
          - >-
            The project number that needs to be allowlisted on the network attachment to enable outbound connectivity, if the network attachment is

            configured to ACCEPT_MANUAL connections.
          - In case the network attachment is configured to ACCEPT_AUTOMATIC, this project number does not need to be allowlisted explicitly.
        type: int
    type: dict
  restore_backup_source:
    description:
      - The source when restoring from a backup.
      - Conflicts with 'restore_continuous_backup_source', both can't be set together.
    suboptions:
      backup_name:
        description:
          - The name of the backup that this cluster is restored from.
        required: true
        type: str
    type: dict
  restore_continuous_backup_source:
    description:
      - The source when restoring via point in time recovery (PITR).
      - Conflicts with 'restore_backup_source', both can't be set together.
    suboptions:
      cluster:
        description:
          - The name of the source cluster that this cluster is restored from.
        required: true
        type: str
      point_in_time:
        description:
          - The point in time that this cluster is restored to, in RFC 3339 format.
        required: true
        type: str
    type: dict
  secondary_config:
    description:
      - Configuration of the secondary cluster for Cross Region Replication.
      - This should be set if and only if the cluster is of type SECONDARY.
    suboptions:
      primary_cluster_name:
        description:
          - Name of the primary cluster must be in the format 'projects/{project}/locations/{location}/clusters/{cluster_id}'.
        required: true
        type: str
    type: dict
  state:
    choices:
      - present
      - absent
    default: present
    description:
      - Whether the resource should exist in GCP.
    type: str
  subscription_type:
    choices:
      - TRIAL
      - STANDARD
    description:
      - The subscrition type of cluster.
    type: str
requirements:
  - python >= 3.8
  - requests >= 2.18.4
  - google-auth >= 2.25.1
short_description: Creates a GCP Alloydb.Cluster resource
"""

EXAMPLES = r"""
- name: Create basic alloydb cluster
  google.cloud.gcp_alloydb_cluster:
    cluster_id: "{{ resource_name }}"
    state: present
    location: us-central1
    network_config:
      network: "projects/{{ gcp_project_number }}/global/networks/{{ resource_name }}"
    initial_user:
      user: pgroot
      password: Test123Test
    project: "{{ gcp_project }}"
    auth_kind: "{{ gcp_cred_kind }}"
    service_account_file: "{{ gcp_cred_file }}"

################################################################################

- name: Create primary alloydb cluster
  google.cloud.gcp_alloydb_cluster:
    cluster_id: "{{ resource_name }}-primary"
    state: present
    location: us-central1
    cluster_type: PRIMARY
    network_config:
      network: "projects/{{ gcp_project }}/global/networks/default"
    project: "{{ gcp_project }}"
    auth_kind: "{{ gcp_cred_kind }}"
    service_account_file: "{{ gcp_cred_file }}"
  register: _primary

- name: Create secondary cluster attached to primary
  google.cloud.gcp_alloydb_cluster:
    cluster_id: "{{ resource_name }}-secondary"
    state: present
    location: us-central1
    cluster_type: SECONDARY
    network_config:
      network: "projects/{{ gcp_project }}/global/networks/default"
    secondary_config:
      primary_cluster_name: "{{ _primary.name }}"
    project: "{{ gcp_project }}"
    auth_kind: "{{ gcp_cred_kind }}"
    service_account_file: "{{ gcp_cred_file }}"
"""

RETURN = r"""
backupSource:
  contains:
    backupName:
      description:
        - The name of the backup resource.
      returned: when set
      type: str
  description:
    - Cluster created from backup.
  returned: success
  type: dict
changed:
  description: Whether the resource was changed.
  returned: always
  type: bool
continuousBackupInfo:
  contains:
    earliestRestorableTime:
      description:
        - The earliest restorable time that can be restored to.
        - Output only field.
      returned: success
      type: str
    enabledTime:
      description:
        - When ContinuousBackup was most recently enabled.
        - Set to null if ContinuousBackup is not enabled.
      returned: success
      type: str
    encryptionInfo:
      contains:
        encryptionType:
          description:
            - Output only.
            - Type of encryption.
          returned: success
          type: str
        kmsKeyVersions:
          description:
            - Output only.
            - Cloud KMS key versions that are being used to protect the database or the backup.
          elements: str
          returned: success
          type: list
      description:
        - Output only.
        - The encryption information for the WALs and backups required for ContinuousBackup.
      returned: success
      type: dict
    schedule:
      description:
        - Days of the week on which a continuous backup is taken.
        - Output only field.
        - Ignored if passed into the request.
      elements: str
      returned: success
      type: list
  description:
    - ContinuousBackupInfo describes the continuous backup properties of a cluster.
  returned: success
  type: dict
encryptionInfo:
  contains:
    encryptionType:
      description:
        - Output only.
        - Type of encryption.
      returned: success
      type: str
    kmsKeyVersions:
      description:
        - Output only.
        - Cloud KMS key versions that are being used to protect the database or the backup.
      elements: str
      returned: success
      type: list
  description:
    - EncryptionInfo describes the encryption information of a cluster or a backup.
  returned: success
  type: dict
migrationSource:
  contains:
    hostPort:
      description:
        - The host and port of the on-premises instance in host:port format.
      returned: when set
      type: str
    referenceId:
      description:
        - Place holder for the external source identifier(e.g DMS job name) that created the cluster.
      returned: when set
      type: str
    sourceType:
      description:
        - Type of migration source.
      returned: when set
      type: str
  description:
    - Cluster created via DMS migration.
  returned: success
  type: dict
name:
  description:
    - The name of the cluster resource.
  returned: success
  type: str
reconciling:
  description:
    - Output only.
    - Reconciling (https://google.aip.dev/128#reconciliation).
    - >-
      Set to true if the current state of Cluster does not match the user's intended state, and the service is actively updating the resource to

      reconcile them.
    - This can happen due to user-triggered updates or system actions like failover or maintenance.
  returned: success
  type: bool
state:
  description:
    - Output only.
    - The current serving state of the cluster.
  returned: success
  type: str
trialMetadata:
  contains:
    endTime:
      description:
        - End time of the trial cluster.
      returned: when set
      type: str
    graceEndTime:
      description:
        - Grace end time of the trial cluster.
      returned: when set
      type: str
    startTime:
      description:
        - Start time of the trial cluster.
      returned: when set
      type: str
    upgradeTime:
      description:
        - Upgrade time of the trial cluster to standard cluster.
      returned: when set
      type: str
  description:
    - Contains information and all metadata related to TRIAL clusters.
  returned: success
  type: dict
uid:
  description:
    - The system-generated UID of the resource.
  returned: success
  type: str
"""

################################################################################
# Imports
################################################################################

from ansible_collections.google.cloud.plugins.module_utils import gcp_utils as gcp

# BEGIN Custom imports
# END Custom imports


def build_link(module, uri):
    params = module.params.copy()

    return "https://alloydb.googleapis.com/v1/" + uri.format(**params)


class AutomatedBackupPolicy(gcp.Resource):
    def _request(self):
        return {
            "backupWindow": self.request.get("backup_window"),
            "enabled": self.request.get("enabled"),
            "encryptionConfig": AutomatedBackupPolicyEncryptionConfig(
                self.request.get("encryption_config", {})
            ).to_request(),
            "labels": self.request.get("labels"),
            "location": self.request.get("location"),
            "quantityBasedRetention": AutomatedBackupPolicyQuantityBasedRetention(
                self.request.get("quantity_based_retention", {})
            ).to_request(),
            "timeBasedRetention": AutomatedBackupPolicyTimeBasedRetention(
                self.request.get("time_based_retention", {})
            ).to_request(),
            "weeklySchedule": AutomatedBackupPolicyWeeklySchedule(self.request.get("weekly_schedule", {})).to_request(),
        }

    def _response(self):
        return {
            "backupWindow": self.response.get("backupWindow"),
            "enabled": self.response.get("enabled"),
            "encryptionConfig": AutomatedBackupPolicyEncryptionConfig().from_response(
                self.response.get("encryptionConfig", {})
            ),
            "labels": self.response.get("labels"),
            "location": self.response.get("location"),
            "quantityBasedRetention": AutomatedBackupPolicyQuantityBasedRetention().from_response(
                self.response.get("quantityBasedRetention", {})
            ),
            "timeBasedRetention": AutomatedBackupPolicyTimeBasedRetention().from_response(
                self.response.get("timeBasedRetention", {})
            ),
            "weeklySchedule": AutomatedBackupPolicyWeeklySchedule().from_response(
                self.response.get("weeklySchedule", {})
            ),
        }


class AutomatedBackupPolicyEncryptionConfig(gcp.Resource):
    def _request(self):
        return {
            "kmsKeyName": self.request.get("kms_key_name"),
        }

    def _response(self):
        return {
            "kmsKeyName": self.response.get("kmsKeyName"),
        }


class AutomatedBackupPolicyQuantityBasedRetention(gcp.Resource):
    def _request(self):
        return {
            "count": self.request.get("count"),
        }

    def _response(self):
        return {
            "count": self.response.get("count"),
        }


class AutomatedBackupPolicyTimeBasedRetention(gcp.Resource):
    def _request(self):
        return {
            "retentionPeriod": self.request.get("retention_period"),
        }

    def _response(self):
        return {
            "retentionPeriod": self.response.get("retentionPeriod"),
        }


class AutomatedBackupPolicyWeeklySchedule(gcp.Resource):
    def _request(self):
        return {
            "daysOfWeek": self.request.get("days_of_week"),
            "startTimes": [
                AutomatedBackupPolicyWeeklyScheduleStartTime(item).to_request()
                for item in (self.request.get("start_times") or [])
            ],
        }

    def _response(self):
        return {
            "daysOfWeek": self.response.get("daysOfWeek"),
            "startTimes": [
                AutomatedBackupPolicyWeeklyScheduleStartTime().from_response(item)
                for item in (self.response.get("startTimes") or [])
            ],
        }


class AutomatedBackupPolicyWeeklyScheduleStartTime(gcp.Resource):
    def _request(self):
        return {
            "hours": self.request.get("hours"),
            "minutes": self.request.get("minutes"),
            "nanos": self.request.get("nanos"),
            "seconds": self.request.get("seconds"),
        }

    def _response(self):
        return {
            "hours": self.response.get("hours"),
            "minutes": self.response.get("minutes"),
            "nanos": self.response.get("nanos"),
            "seconds": self.response.get("seconds"),
        }


class BackupSource(gcp.Resource):
    def _request(self):
        return {
            "backupName": self.request.get("backup_name"),
        }

    def _response(self):
        return {
            "backupName": self.response.get("backupName"),
        }


class ContinuousBackupConfig(gcp.Resource):
    def _request(self):
        return {
            "enabled": self.request.get("enabled"),
            "encryptionConfig": ContinuousBackupConfigEncryptionConfig(
                self.request.get("encryption_config", {})
            ).to_request(),
            "recoveryWindowDays": self.request.get("recovery_window_days"),
        }

    def _response(self):
        return {
            "enabled": self.response.get("enabled"),
            "encryptionConfig": ContinuousBackupConfigEncryptionConfig().from_response(
                self.response.get("encryptionConfig", {})
            ),
            "recoveryWindowDays": self.response.get("recoveryWindowDays"),
        }


class ContinuousBackupConfigEncryptionConfig(gcp.Resource):
    def _request(self):
        return {
            "kmsKeyName": self.request.get("kms_key_name"),
        }

    def _response(self):
        return {
            "kmsKeyName": self.response.get("kmsKeyName"),
        }


class ContinuousBackupInfo(gcp.Resource):
    def _response(self):
        return {
            "earliestRestorableTime": self.response.get("earliestRestorableTime"),
            "enabledTime": self.response.get("enabledTime"),
            "encryptionInfo": ContinuousBackupInfoEncryptionInfo().from_response(
                self.response.get("encryptionInfo", {})
            ),
            "schedule": self.response.get("schedule"),
        }


class ContinuousBackupInfoEncryptionInfo(gcp.Resource):
    def _response(self):
        return {
            "encryptionType": self.response.get("encryptionType"),
            "kmsKeyVersions": self.response.get("kmsKeyVersions"),
        }


class EncryptionConfig(gcp.Resource):
    def _request(self):
        return {
            "kmsKeyName": self.request.get("kms_key_name"),
        }

    def _response(self):
        return {
            "kmsKeyName": self.response.get("kmsKeyName"),
        }


class EncryptionInfo(gcp.Resource):
    def _response(self):
        return {
            "encryptionType": self.response.get("encryptionType"),
            "kmsKeyVersions": self.response.get("kmsKeyVersions"),
        }


class InitialUser(gcp.Resource):
    def _request(self):
        return {
            "password": self.request.get("password"),
            "user": self.request.get("user"),
        }

    def _response(self):
        return {
            "password": self.response.get("password"),
            "user": self.response.get("user"),
        }


class MaintenanceUpdatePolicy(gcp.Resource):
    def _request(self):
        return {
            "maintenanceWindows": [
                MaintenanceUpdatePolicyMaintenanceWindow(item).to_request()
                for item in (self.request.get("maintenance_windows") or [])
            ],
        }

    def _response(self):
        return {
            "maintenanceWindows": [
                MaintenanceUpdatePolicyMaintenanceWindow().from_response(item)
                for item in (self.response.get("maintenanceWindows") or [])
            ],
        }


class MaintenanceUpdatePolicyMaintenanceWindow(gcp.Resource):
    def _request(self):
        return {
            "day": self.request.get("day"),
            "startTime": MaintenanceUpdatePolicyMaintenanceWindowStartTime(
                self.request.get("start_time", {})
            ).to_request(),
        }

    def _response(self):
        return {
            "day": self.response.get("day"),
            "startTime": MaintenanceUpdatePolicyMaintenanceWindowStartTime().from_response(
                self.response.get("startTime", {})
            ),
        }


class MaintenanceUpdatePolicyMaintenanceWindowStartTime(gcp.Resource):
    def _request(self):
        return {
            "hours": self.request.get("hours"),
            "minutes": self.request.get("minutes"),
            "nanos": self.request.get("nanos"),
            "seconds": self.request.get("seconds"),
        }

    def _response(self):
        return {
            "hours": self.response.get("hours"),
            "minutes": self.response.get("minutes"),
            "nanos": self.response.get("nanos"),
            "seconds": self.response.get("seconds"),
        }


class MigrationSource(gcp.Resource):
    def _request(self):
        return {
            "hostPort": self.request.get("host_port"),
            "referenceId": self.request.get("reference_id"),
            "sourceType": self.request.get("source_type"),
        }

    def _response(self):
        return {
            "hostPort": self.response.get("hostPort"),
            "referenceId": self.response.get("referenceId"),
            "sourceType": self.response.get("sourceType"),
        }


class NetworkConfig(gcp.Resource):
    def _request(self):
        return {
            "allocatedIpRange": self.request.get("allocated_ip_range"),
            "network": self.request.get("network"),
        }

    def _response(self):
        return {
            "allocatedIpRange": self.response.get("allocatedIpRange"),
            "network": self.response.get("network"),
        }


class PscConfig(gcp.Resource):
    def _request(self):
        return {
            "pscEnabled": self.request.get("psc_enabled"),
        }

    def _response(self):
        return {
            "pscEnabled": self.response.get("pscEnabled"),
            "serviceOwnedProjectNumber": self.response.get("serviceOwnedProjectNumber"),
        }


class RestoreBackupSource(gcp.Resource):
    def _request(self):
        return {
            "backupName": self.request.get("backup_name"),
        }

    def _response(self):
        return {
            "backupName": self.response.get("backupName"),
        }


class RestoreContinuousBackupSource(gcp.Resource):
    def _request(self):
        return {
            "cluster": self.request.get("cluster"),
            "pointInTime": self.request.get("point_in_time"),
        }

    def _response(self):
        return {
            "cluster": self.response.get("cluster"),
            "pointInTime": self.response.get("pointInTime"),
        }


class SecondaryConfig(gcp.Resource):
    def _request(self):
        return {
            "primaryClusterName": self.request.get("primary_cluster_name"),
        }

    def _response(self):
        return {
            "primaryClusterName": self.response.get("primaryClusterName"),
        }


class TrialMetadata(gcp.Resource):
    def _request(self):
        return {
            "endTime": self.request.get("end_time"),
            "graceEndTime": self.request.get("grace_end_time"),
            "startTime": self.request.get("start_time"),
            "upgradeTime": self.request.get("upgrade_time"),
        }

    def _response(self):
        return {
            "endTime": self.response.get("endTime"),
            "graceEndTime": self.response.get("graceEndTime"),
            "startTime": self.response.get("startTime"),
            "upgradeTime": self.response.get("upgradeTime"),
        }


class Alloydb(gcp.Resource):
    def _request(self):
        return {
            "annotations": self.request.get("annotations"),
            "automatedBackupPolicy": AutomatedBackupPolicy(
                self.request.get("automated_backup_policy", {})
            ).to_request(),
            "clusterType": self.request.get("cluster_type"),
            "continuousBackupConfig": ContinuousBackupConfig(
                self.request.get("continuous_backup_config", {})
            ).to_request(),
            "databaseVersion": self.request.get("database_version"),
            "displayName": self.request.get("display_name"),
            "encryptionConfig": EncryptionConfig(self.request.get("encryption_config", {})).to_request(),
            "etag": self.request.get("etag"),
            "initialUser": InitialUser(self.request.get("initial_user", {})).to_request(),
            "labels": self.request.get("labels"),
            "maintenanceUpdatePolicy": MaintenanceUpdatePolicy(
                self.request.get("maintenance_update_policy", {})
            ).to_request(),
            "networkConfig": NetworkConfig(self.request.get("network_config", {})).to_request(),
            "pscConfig": PscConfig(self.request.get("psc_config", {})).to_request(),
            "restoreBackupSource": RestoreBackupSource(self.request.get("restore_backup_source", {})).to_request(),
            "restoreContinuousBackupSource": RestoreContinuousBackupSource(
                self.request.get("restore_continuous_backup_source", {})
            ).to_request(),
            "secondaryConfig": SecondaryConfig(self.request.get("secondary_config", {})).to_request(),
            "subscriptionType": self.request.get("subscription_type"),
        }

    def _response(self):
        return {
            "annotations": self.response.get("annotations"),
            "automatedBackupPolicy": AutomatedBackupPolicy().from_response(
                self.response.get("automatedBackupPolicy", {})
            ),
            "backupSource": BackupSource().from_response(self.response.get("backupSource", {})),
            "clusterType": self.response.get("clusterType"),
            "continuousBackupConfig": ContinuousBackupConfig().from_response(
                self.response.get("continuousBackupConfig", {})
            ),
            "continuousBackupInfo": ContinuousBackupInfo().from_response(self.response.get("continuousBackupInfo", {})),
            "databaseVersion": self.response.get("databaseVersion"),
            "displayName": self.response.get("displayName"),
            "encryptionConfig": EncryptionConfig().from_response(self.response.get("encryptionConfig", {})),
            "encryptionInfo": EncryptionInfo().from_response(self.response.get("encryptionInfo", {})),
            "etag": self.response.get("etag"),
            "initialUser": InitialUser().from_response(self.response.get("initialUser", {})),
            "labels": self.response.get("labels"),
            "maintenanceUpdatePolicy": MaintenanceUpdatePolicy().from_response(
                self.response.get("maintenanceUpdatePolicy", {})
            ),
            "migrationSource": MigrationSource().from_response(self.response.get("migrationSource", {})),
            "name": self.response.get("name"),
            "networkConfig": NetworkConfig().from_response(self.response.get("networkConfig", {})),
            "pscConfig": PscConfig().from_response(self.response.get("pscConfig", {})),
            "reconciling": self.response.get("reconciling"),
            "restoreBackupSource": RestoreBackupSource().from_response(self.response.get("restoreBackupSource", {})),
            "restoreContinuousBackupSource": RestoreContinuousBackupSource().from_response(
                self.response.get("restoreContinuousBackupSource", {})
            ),
            "secondaryConfig": SecondaryConfig().from_response(self.response.get("secondaryConfig", {})),
            "subscriptionType": self.response.get("subscriptionType"),
            "trialMetadata": TrialMetadata().from_response(self.response.get("trialMetadata", {})),
            "uid": self.response.get("uid"),
        }


################################################################################
# Main
################################################################################


def main():
    """Main function"""

    module = gcp.Module(
        argument_spec=dict(
            state=dict(
                type="str",
                default="present",
                choices=["present", "absent"],
            ),
            annotations=dict(
                type="dict",
            ),
            automated_backup_policy=dict(
                type="dict",
                options=dict(
                    backup_window=dict(
                        type="str",
                    ),
                    enabled=dict(
                        type="bool",
                    ),
                    encryption_config=dict(
                        type="dict",
                        options=dict(
                            kms_key_name=dict(
                                type="str",
                            )
                        ),
                    ),
                    labels=dict(
                        type="dict",
                    ),
                    location=dict(
                        type="str",
                    ),
                    quantity_based_retention=dict(
                        type="dict",
                        options=dict(
                            count=dict(
                                type="int",
                            )
                        ),
                    ),
                    time_based_retention=dict(
                        type="dict",
                        options=dict(
                            retention_period=dict(
                                type="str",
                            )
                        ),
                    ),
                    weekly_schedule=dict(
                        type="dict",
                        options=dict(
                            days_of_week=dict(
                                type="list",
                                elements="str",
                            ),
                            start_times=dict(
                                type="list",
                                required=True,
                                elements="dict",
                                options=dict(
                                    hours=dict(
                                        type="int",
                                    ),
                                    minutes=dict(
                                        type="int",
                                    ),
                                    nanos=dict(
                                        type="int",
                                    ),
                                    seconds=dict(
                                        type="int",
                                    ),
                                ),
                            ),
                        ),
                    ),
                ),
                mutually_exclusive=[["quantity_based_retention", "time_based_retention"]],
            ),
            cluster_id=dict(
                type="str",
                required=True,
            ),
            cluster_type=dict(
                type="str",
                default="PRIMARY",
                choices=["PRIMARY", "SECONDARY"],
            ),
            continuous_backup_config=dict(
                type="dict",
                options=dict(
                    enabled=dict(
                        type="bool",
                        default=True,
                    ),
                    encryption_config=dict(
                        type="dict",
                        options=dict(
                            kms_key_name=dict(
                                type="str",
                            )
                        ),
                    ),
                    recovery_window_days=dict(
                        type="int",
                    ),
                ),
            ),
            database_version=dict(
                type="str",
            ),
            display_name=dict(
                type="str",
            ),
            encryption_config=dict(
                type="dict",
                options=dict(
                    kms_key_name=dict(
                        type="str",
                    )
                ),
            ),
            etag=dict(
                type="str",
            ),
            initial_user=dict(
                type="dict",
                required=True,
                options=dict(
                    password=dict(
                        type="str",
                        required=True,
                        no_log=True,
                    ),
                    user=dict(
                        type="str",
                    ),
                ),
            ),
            labels=dict(
                type="dict",
            ),
            location=dict(
                type="str",
                required=True,
            ),
            maintenance_update_policy=dict(
                type="dict",
                options=dict(
                    maintenance_windows=dict(
                        type="list",
                        elements="dict",
                        options=dict(
                            day=dict(
                                type="str",
                                required=True,
                                choices=["MONDAY", "TUESDAY", "WEDNESDAY", "THURSDAY", "FRIDAY", "SATURDAY", "SUNDAY"],
                            ),
                            start_time=dict(
                                type="dict",
                                required=True,
                                options=dict(
                                    hours=dict(
                                        type="int",
                                        required=True,
                                    ),
                                    minutes=dict(
                                        type="int",
                                    ),
                                    nanos=dict(
                                        type="int",
                                    ),
                                    seconds=dict(
                                        type="int",
                                    ),
                                ),
                            ),
                        ),
                    )
                ),
            ),
            network_config=dict(
                type="dict",
                options=dict(
                    allocated_ip_range=dict(
                        type="str",
                    ),
                    network=dict(
                        type="str",
                    ),
                ),
            ),
            psc_config=dict(
                type="dict",
                options=dict(
                    psc_enabled=dict(
                        type="bool",
                    ),
                    service_owned_project_number=dict(
                        type="int",
                    ),
                ),
            ),
            restore_backup_source=dict(
                type="dict",
                options=dict(
                    backup_name=dict(
                        type="str",
                        required=True,
                    )
                ),
            ),
            restore_continuous_backup_source=dict(
                type="dict",
                options=dict(
                    cluster=dict(
                        type="str",
                        required=True,
                    ),
                    point_in_time=dict(
                        type="str",
                        required=True,
                    ),
                ),
            ),
            secondary_config=dict(
                type="dict",
                options=dict(
                    primary_cluster_name=dict(
                        type="str",
                        required=True,
                    )
                ),
            ),
            subscription_type=dict(
                type="str",
                choices=["TRIAL", "STANDARD"],
            ),
        ),
        mutually_exclusive=[["restore_backup_source", "restore_continuous_backup_source"]],
    )

    if not module.params["scopes"]:
        module.params["scopes"] = ["https://www.googleapis.com/auth/cloud-platform"]

    state = module.params["state"]
    changed = False

    op_configs = gcp.ResourceOpConfigs(
        {
            "create": gcp.ResourceOpConfig(
                **{
                    "uri": "projects/{project}/locations/{location}/clusters?clusterId={cluster_id}",
                    "async_uri": "{op_id}",
                    "verb": "POST",
                    "timeout_minutes": 120,
                }
            ),
            "delete": gcp.ResourceOpConfig(
                **{
                    "uri": "projects/{project}/locations/{location}/clusters/{cluster_id}",
                    "async_uri": "{op_id}",
                    "verb": "DELETE",
                    "timeout_minutes": 120,
                }
            ),
            "read": gcp.ResourceOpConfig(
                **{
                    "uri": "projects/{project}/locations/{location}/clusters/{cluster_id}",
                    "async_uri": "",
                    "verb": "GET",
                    "timeout_minutes": 0,
                }
            ),
            "update": gcp.ResourceOpConfig(
                **{
                    "uri": "projects/{project}/locations/{location}/clusters/{cluster_id}",
                    "async_uri": "{op_id}",
                    "verb": "PATCH",
                    "timeout_minutes": 120,
                }
            ),
        }
    )

    params = gcp.remove_nones_from_dict(module.params)
    resource = Alloydb(params, module=module, product="Alloydb", kind="alloydb#cluster")
    existing_obj = resource.get(build_link(module, op_configs.read.uri), allow_not_found=True)

    if existing_obj is None:
        if state == "present":
            is_async = op_configs.create.async_uri != ""
            create_link = build_link(module, op_configs.create.uri)
            create_retries = op_configs.create.timeout
            create_func = getattr(resource, op_configs.create.verb)
            async_create_func = getattr(resource, op_configs.create.verb + "_async")
            async_create_link = build_link(module, "") + op_configs.create.async_uri
            # --------- BEGIN custom pre-create code ---------
            secondary_config = module.params.get("secondary_config")
            cluster_type = module.params.get("cluster_type")
            if (cluster_type == "SECONDARY" and secondary_config is None) or (
                cluster_type == "PRIMARY" and secondary_config is not None
            ):
                module.fail_json(msg="A secondary_config is ONLY needed when cluster_type=SECONDARY")

            # for secondary clusters, the creation link changes slightly
            if cluster_type == "SECONDARY":
                create_link = create_link.replace("clusters?clusterId", "clusters:createsecondary?cluster_id")
            # --------- END custom pre-create code ---------
            try:
                if is_async:
                    new_obj = async_create_func(create_link, async_link=async_create_link, retries=create_retries)
                else:
                    new_obj = create_func(create_link)
                changed = True
            except Exception as e:
                module.fail_json(msg=str(e))
        else:
            pass  # nothing to do
    else:
        if state == "absent":
            is_async = op_configs.delete.async_uri != ""
            delete_link = build_link(module, op_configs.delete.uri)
            delete_retries = op_configs.delete.timeout
            delete_func = getattr(resource, op_configs.delete.verb)
            async_delete_func = getattr(resource, op_configs.delete.verb + "_async")
            async_delete_link = build_link(module, "") + op_configs.delete.async_uri
            # --------- BEGIN custom pre-delete code ---------
            # noop
            # --------- END custom pre-delete code ---------
            try:
                if is_async:
                    new_obj = async_delete_func(delete_link, async_link=async_delete_link, retries=delete_retries)
                else:
                    new_obj = delete_func(delete_link)
                changed = True
            except Exception as e:
                module.fail_json(msg=str(e))
        else:
            if resource.diff(existing_obj):
                is_async = op_configs.update.async_uri != ""
                update_link = build_link(module, op_configs.update.uri)
                update_retries = op_configs.update.timeout
                update_func = getattr(resource, op_configs.update.verb)
                async_update_func = getattr(resource, op_configs.update.verb + "_async")
                async_update_link = build_link(module, "") + op_configs.update.async_uri
                # --------- BEGIN custom pre-update code ---------
                secondary_config = module.params.get("secondary_config")
                cluster_type = module.params.get("cluster_type")
                db_version = module.params.get("database_version")

                # validate you're not sending secondary config when cluster is primary and vice versa
                if (cluster_type == "SECONDARY" and secondary_config is None) or (
                    cluster_type == "PRIMARY" and secondary_config is not None
                ):
                    module.fail_json(msg="A secondary_config is ONLY needed when cluster_type=SECONDARY")

                # handle cluster promotions primary<->secondary
                if cluster_type != existing_obj.get("clusterType"):
                    module.fail_json(msg="Cluster promotion not supported yet")

                # handle database engine migration
                if db_version is not None and db_version != existing_obj.get("databaseVersion"):
                    module.fail_json(msg="Database migration not supported yet")

                # finally, need to build the updateMask for the fields in our module
                update_link += "?updateMask=" + ",".join(resource.dot_fields())
                # --------- END custom pre-update code ---------
                try:
                    if is_async:
                        new_obj = async_update_func(update_link, async_link=async_update_link, retries=update_retries)
                    else:
                        new_obj = update_func(update_link)
                except Exception as e:
                    module.fail_json(msg=str(e))
                changed = resource.diff(new_obj)

    new_obj = resource.get(build_link(module, op_configs.read.uri), allow_not_found=True)
    new_obj = resource.from_response(new_obj or {})

    new_obj.update({"changed": changed})
    module.exit_json(**new_obj)


if __name__ == "__main__":
    main()
