/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.builtins.temporal;

import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedBranchProfile;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;
import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.js.builtins.JSBuiltinsContainer;
import com.oracle.truffle.js.builtins.temporal.JSTemporalBuiltinOperation;
import com.oracle.truffle.js.builtins.temporal.TemporalPlainYearMonthPrototypeBuiltinsFactory;
import com.oracle.truffle.js.builtins.temporal.UnsupportedValueOfNodeGen;
import com.oracle.truffle.js.nodes.function.JSBuiltin;
import com.oracle.truffle.js.nodes.function.JSBuiltinNode;
import com.oracle.truffle.js.nodes.intl.GetOptionsObjectNode;
import com.oracle.truffle.js.nodes.temporal.GetDifferenceSettingsNode;
import com.oracle.truffle.js.nodes.temporal.IsPartialTemporalObjectNode;
import com.oracle.truffle.js.nodes.temporal.RoundRelativeDurationNode;
import com.oracle.truffle.js.nodes.temporal.TemporalAddDateNode;
import com.oracle.truffle.js.nodes.temporal.TemporalCalendarDateFromFieldsNode;
import com.oracle.truffle.js.nodes.temporal.TemporalGetOptionNode;
import com.oracle.truffle.js.nodes.temporal.TemporalYearMonthFromFieldsNode;
import com.oracle.truffle.js.nodes.temporal.ToTemporalCalendarIdentifierNode;
import com.oracle.truffle.js.nodes.temporal.ToTemporalDurationNode;
import com.oracle.truffle.js.nodes.temporal.ToTemporalYearMonthNode;
import com.oracle.truffle.js.runtime.BigInt;
import com.oracle.truffle.js.runtime.Errors;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.JSRealm;
import com.oracle.truffle.js.runtime.JSRuntime;
import com.oracle.truffle.js.runtime.Strings;
import com.oracle.truffle.js.runtime.builtins.BuiltinEnum;
import com.oracle.truffle.js.runtime.builtins.JSDate;
import com.oracle.truffle.js.runtime.builtins.temporal.ISODateRecord;
import com.oracle.truffle.js.runtime.builtins.temporal.ISODateTimeRecord;
import com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalDuration;
import com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalDurationObject;
import com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalDurationRecord;
import com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalPlainDate;
import com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalPlainDateObject;
import com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalPlainYearMonth;
import com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalPlainYearMonthObject;
import com.oracle.truffle.js.runtime.builtins.temporal.NormalizedDurationRecord;
import com.oracle.truffle.js.runtime.objects.JSDynamicObject;
import com.oracle.truffle.js.runtime.objects.JSObject;
import com.oracle.truffle.js.runtime.objects.Undefined;
import com.oracle.truffle.js.runtime.util.IntlUtil;
import com.oracle.truffle.js.runtime.util.TemporalConstants;
import com.oracle.truffle.js.runtime.util.TemporalErrors;
import com.oracle.truffle.js.runtime.util.TemporalUtil;
import java.util.EnumSet;
import org.graalvm.shadowed.com.ibm.icu.util.Calendar;

public class TemporalPlainYearMonthPrototypeBuiltins
extends JSBuiltinsContainer.SwitchEnum<TemporalPlainYearMonthPrototype> {
    public static final JSBuiltinsContainer BUILTINS = new TemporalPlainYearMonthPrototypeBuiltins();

    protected TemporalPlainYearMonthPrototypeBuiltins() {
        super(JSTemporalPlainYearMonth.PROTOTYPE_NAME, TemporalPlainYearMonthPrototype.class);
    }

    @Override
    protected Object createNode(JSContext context, JSBuiltin builtin, boolean construct, boolean newTarget, TemporalPlainYearMonthPrototype builtinEnum) {
        switch (builtinEnum.ordinal()) {
            case 0: {
                return TemporalPlainYearMonthPrototypeBuiltinsFactory.JSTemporalPlainYearMonthCalendarGetterNodeGen.create(context, builtin, TemporalPlainYearMonthPrototypeBuiltins.args().withThis().createArgumentNodes(context));
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                return TemporalPlainYearMonthPrototypeBuiltinsFactory.JSTemporalPlainYearMonthGetterNodeGen.create(context, builtin, builtinEnum, TemporalPlainYearMonthPrototypeBuiltins.args().withThis().createArgumentNodes(context));
            }
            case 11: {
                return TemporalPlainYearMonthPrototypeBuiltinsFactory.JSTemporalPlainYearMonthAddSubNodeGen.create(context, builtin, 1, TemporalPlainYearMonthPrototypeBuiltins.args().withThis().fixedArgs(2).createArgumentNodes(context));
            }
            case 12: {
                return TemporalPlainYearMonthPrototypeBuiltinsFactory.JSTemporalPlainYearMonthAddSubNodeGen.create(context, builtin, -1, TemporalPlainYearMonthPrototypeBuiltins.args().withThis().fixedArgs(2).createArgumentNodes(context));
            }
            case 13: {
                return TemporalPlainYearMonthPrototypeBuiltinsFactory.JSTemporalPlainYearMonthUntilSinceNodeGen.create(context, builtin, 1, TemporalPlainYearMonthPrototypeBuiltins.args().withThis().fixedArgs(2).createArgumentNodes(context));
            }
            case 14: {
                return TemporalPlainYearMonthPrototypeBuiltinsFactory.JSTemporalPlainYearMonthUntilSinceNodeGen.create(context, builtin, -1, TemporalPlainYearMonthPrototypeBuiltins.args().withThis().fixedArgs(2).createArgumentNodes(context));
            }
            case 10: {
                return TemporalPlainYearMonthPrototypeBuiltinsFactory.JSTemporalPlainYearMonthWithNodeGen.create(context, builtin, TemporalPlainYearMonthPrototypeBuiltins.args().withThis().fixedArgs(2).createArgumentNodes(context));
            }
            case 15: {
                return TemporalPlainYearMonthPrototypeBuiltinsFactory.JSTemporalPlainYearMonthEqualsNodeGen.create(context, builtin, TemporalPlainYearMonthPrototypeBuiltins.args().withThis().fixedArgs(1).createArgumentNodes(context));
            }
            case 20: {
                return TemporalPlainYearMonthPrototypeBuiltinsFactory.JSTemporalPlainYearMonthToPlainDateNodeGen.create(context, builtin, TemporalPlainYearMonthPrototypeBuiltins.args().withThis().fixedArgs(1).createArgumentNodes(context));
            }
            case 16: {
                return TemporalPlainYearMonthPrototypeBuiltinsFactory.JSTemporalPlainYearMonthToStringNodeGen.create(context, builtin, TemporalPlainYearMonthPrototypeBuiltins.args().withThis().fixedArgs(1).createArgumentNodes(context));
            }
            case 17: 
            case 18: {
                return TemporalPlainYearMonthPrototypeBuiltinsFactory.JSTemporalPlainYearMonthToLocaleStringNodeGen.create(context, builtin, TemporalPlainYearMonthPrototypeBuiltins.args().withThis().createArgumentNodes(context));
            }
            case 19: {
                return UnsupportedValueOfNodeGen.create(context, builtin, TemporalPlainYearMonthPrototypeBuiltins.args().withThis().createArgumentNodes(context));
            }
        }
        return null;
    }

    public static enum TemporalPlainYearMonthPrototype implements BuiltinEnum<TemporalPlainYearMonthPrototype>
    {
        calendarId(0),
        era(0),
        eraYear(0),
        year(0),
        month(0),
        monthCode(0),
        daysInMonth(0),
        daysInYear(0),
        monthsInYear(0),
        inLeapYear(0),
        with(1),
        add(1),
        subtract(1),
        until(1),
        since(1),
        equals(1),
        toString(0),
        toLocaleString(0),
        toJSON(0),
        valueOf(0),
        toPlainDate(1);

        private final int length;

        private TemporalPlainYearMonthPrototype(int length) {
            this.length = length;
        }

        @Override
        public int getLength() {
            return this.length;
        }

        @Override
        public boolean isGetter() {
            return EnumSet.of(calendarId, new TemporalPlainYearMonthPrototype[]{era, eraYear, year, month, monthCode, daysInMonth, daysInYear, monthsInYear, inLeapYear}).contains(this);
        }
    }

    public static abstract class JSTemporalPlainYearMonthCalendarGetterNode
    extends JSBuiltinNode {
        protected JSTemporalPlainYearMonthCalendarGetterNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        protected TruffleString calendarId(JSTemporalPlainYearMonthObject yearMonth, @Cached ToTemporalCalendarIdentifierNode toCalendarIdentifier) {
            return toCalendarIdentifier.executeString(yearMonth.getCalendar());
        }

        @Specialization(guards={"!isJSTemporalYearMonth(yearMonth)"})
        protected static TruffleString invalidReceiver(Object yearMonth) {
            throw TemporalErrors.createTypeErrorTemporalPlainYearMonthExpected();
        }
    }

    public static abstract class JSTemporalPlainYearMonthGetterNode
    extends JSBuiltinNode {
        protected final TemporalPlainYearMonthPrototype property;

        protected JSTemporalPlainYearMonthGetterNode(JSContext context, JSBuiltin builtin, TemporalPlainYearMonthPrototype property) {
            super(context, builtin);
            this.property = property;
        }

        @Specialization
        protected Object dateGetter(JSTemporalPlainYearMonthObject temporalYM, @Cached TruffleString.EqualNode equalNode, @Cached InlinedConditionProfile isoCalendarProfile) {
            TruffleString calendar = temporalYM.getCalendar();
            boolean isoCalendar = isoCalendarProfile.profile((Node)this, Strings.equals(equalNode, TemporalConstants.ISO8601, calendar));
            Calendar cal = null;
            if (!isoCalendar) {
                cal = IntlUtil.getCalendar(calendar, temporalYM.getYear(), temporalYM.getMonth(), temporalYM.getDay());
            }
            switch (this.property.ordinal()) {
                case 1: {
                    return isoCalendar ? Undefined.instance : IntlUtil.getEra(cal);
                }
                case 2: {
                    return isoCalendar ? Undefined.instance : IntlUtil.getEraYear(cal);
                }
                case 3: {
                    return isoCalendar ? temporalYM.getYear() : IntlUtil.getCalendarField(cal, 19);
                }
                case 4: {
                    return isoCalendar ? temporalYM.getMonth() : IntlUtil.getCalendarField(cal, 23) + 1;
                }
                case 5: {
                    return isoCalendar ? TemporalUtil.buildISOMonthCode(temporalYM.getMonth()) : Strings.fromJavaString(IntlUtil.getTemporalMonthCode(cal));
                }
                case 7: {
                    return isoCalendar ? TemporalUtil.isoDaysInYear(temporalYM.getYear()) : IntlUtil.getCalendarFieldMax(cal, 6);
                }
                case 6: {
                    return isoCalendar ? TemporalUtil.isoDaysInMonth(temporalYM.getYear(), temporalYM.getMonth()) : IntlUtil.getCalendarFieldMax(cal, 5);
                }
                case 8: {
                    return isoCalendar ? 12 : IntlUtil.getCalendarFieldMax(cal, 23) + 1;
                }
                case 9: {
                    return isoCalendar ? JSDate.isLeapYear(temporalYM.getYear()) : IntlUtil.isLeapYear(cal);
                }
            }
            throw Errors.shouldNotReachHere();
        }

        @Specialization(guards={"!isJSTemporalYearMonth(thisObj)"})
        protected static Object invalidReceiver(Object thisObj) {
            throw TemporalErrors.createTypeErrorTemporalPlainYearMonthExpected();
        }
    }

    public static abstract class JSTemporalPlainYearMonthAddSubNode
    extends JSTemporalBuiltinOperation {
        private final int operation;

        protected JSTemporalPlainYearMonthAddSubNode(JSContext context, JSBuiltin builtin, int operation) {
            super(context, builtin);
            this.operation = operation;
        }

        @Specialization
        protected JSTemporalPlainYearMonthObject addDurationToOrSubtractDurationFromPlainYearMonth(JSTemporalPlainYearMonthObject yearMonth, Object temporalDurationLike, Object options, @Bind Node node, @Cached ToTemporalDurationNode toTemporalDurationNode, @Cached TemporalGetOptionNode getOptionNode, @Cached TemporalAddDateNode addDateNode, @Cached TemporalYearMonthFromFieldsNode yearMonthFromFieldsNode, @Cached TemporalCalendarDateFromFieldsNode dateFromFieldsNode, @Cached InlinedBranchProfile errorBranch, @Cached InlinedConditionProfile optionUndefined) {
            JSTemporalPlainDateObject date;
            JSContext ctx = this.getContext();
            JSRealm realm = this.getRealm();
            JSTemporalDurationObject duration = toTemporalDurationNode.execute(temporalDurationLike);
            if (this.operation == -1) {
                duration = JSTemporalDuration.createNegatedTemporalDuration(ctx, realm, duration);
            }
            JSDynamicObject resolvedOptions = this.getOptionsObject(options, node, errorBranch, optionUndefined);
            TemporalUtil.Overflow overflow = TemporalUtil.getTemporalOverflowOption((Object)resolvedOptions, getOptionNode);
            int sign = TemporalUtil.durationSign(duration.getYears(), duration.getMonths(), duration.getWeeks(), duration.getDays(), duration.getHours(), duration.getMinutes(), duration.getSeconds(), duration.getMilliseconds(), duration.getMicroseconds(), duration.getNanoseconds());
            TruffleString calendar = yearMonth.getCalendar();
            JSObject fields = TemporalUtil.isoDateToFields(ctx, calendar, yearMonth.isoDate(), TemporalUtil.FieldsType.YEAR_MONTH);
            TemporalUtil.createDataPropertyOrThrow(ctx, fields, TemporalConstants.DAY, 1);
            JSTemporalPlainDateObject intermediateDate = dateFromFieldsNode.execute(calendar, fields, TemporalUtil.Overflow.CONSTRAIN);
            if (sign < 0) {
                JSTemporalDurationObject oneMonthDuration = JSTemporalDuration.createTemporalDuration(ctx, realm, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, node, errorBranch);
                JSTemporalPlainDateObject nextMonth = addDateNode.execute(calendar, intermediateDate, oneMonthDuration, TemporalUtil.Overflow.CONSTRAIN);
                ISODateRecord record = TemporalUtil.balanceISODate(nextMonth.getYear(), nextMonth.getMonth(), nextMonth.getDay() - 1);
                date = JSTemporalPlainDate.create(ctx, realm, record.year(), record.month(), record.day(), calendar, node, errorBranch);
            } else {
                date = intermediateDate;
            }
            JSTemporalDurationObject durationToAdd = TemporalUtil.toDateDurationRecordWithoutTime(ctx, realm, duration, this, errorBranch);
            JSTemporalPlainDateObject addedDate = addDateNode.execute(calendar, date, durationToAdd, overflow);
            JSObject addedDateFields = TemporalUtil.isoDateToFields(ctx, calendar, addedDate.isoDate(), TemporalUtil.FieldsType.YEAR_MONTH);
            return yearMonthFromFieldsNode.execute(calendar, addedDateFields, overflow);
        }

        @Specialization(guards={"!isJSTemporalYearMonth(thisObj)"})
        protected static Object invalidReceiver(Object thisObj, Object temporalDurationLike, Object optParam) {
            throw TemporalErrors.createTypeErrorTemporalPlainYearMonthExpected();
        }
    }

    public static abstract class JSTemporalPlainYearMonthUntilSinceNode
    extends JSTemporalBuiltinOperation {
        private final int sign;

        protected JSTemporalPlainYearMonthUntilSinceNode(JSContext context, JSBuiltin builtin, int sign) {
            super(context, builtin);
            this.sign = sign;
        }

        @Specialization
        protected JSTemporalDurationObject differenceTemporalPlainYearMonth(JSTemporalPlainYearMonthObject yearMonth, Object otherParam, Object options, @Bind Node node, @Cached ToTemporalCalendarIdentifierNode toCalendarIdentifier, @Cached GetDifferenceSettingsNode getDifferenceSettings, @Cached RoundRelativeDurationNode roundRelativeDuration, @Cached ToTemporalYearMonthNode toTemporalYearMonthNode, @Cached TemporalCalendarDateFromFieldsNode dateFromFieldsNode, @Cached InlinedBranchProfile errorBranch, @Cached InlinedConditionProfile optionUndefined) {
            boolean roundingGranularityIsNoop;
            JSTemporalPlainYearMonthObject other = toTemporalYearMonthNode.execute(otherParam, (Object)Undefined.instance);
            TruffleString calendar = yearMonth.getCalendar();
            if (!TemporalUtil.calendarEquals(calendar, other.getCalendar(), toCalendarIdentifier)) {
                errorBranch.enter(node);
                throw TemporalErrors.createRangeErrorIdenticalCalendarExpected();
            }
            JSDynamicObject resolvedOptions = this.getOptionsObject(options, node, errorBranch, optionUndefined);
            GetDifferenceSettingsNode.GetDifferenceSettingsResult settings = getDifferenceSettings.execute(this.sign, resolvedOptions, TemporalUtil.unitMappingYearMonthOrAuto, TemporalUtil.unitMappingYearMonth, TemporalUtil.Unit.MONTH, TemporalUtil.Unit.YEAR);
            JSContext ctx = this.getContext();
            JSRealm realm = this.getRealm();
            if (TemporalUtil.compareISODate(yearMonth.getYear(), yearMonth.getMonth(), yearMonth.getDay(), other.getYear(), other.getMonth(), other.getDay()) == 0) {
                return JSTemporalDuration.createTemporalDuration(ctx, realm, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, node, errorBranch);
            }
            JSObject thisFields = TemporalUtil.isoDateToFields(ctx, calendar, yearMonth.isoDate(), TemporalUtil.FieldsType.YEAR_MONTH);
            TemporalUtil.createDataPropertyOrThrow(ctx, thisFields, TemporalConstants.DAY, 1);
            JSTemporalPlainDateObject thisDate = dateFromFieldsNode.execute(calendar, thisFields, TemporalUtil.Overflow.CONSTRAIN);
            JSObject otherFields = TemporalUtil.isoDateToFields(ctx, calendar, other.isoDate(), TemporalUtil.FieldsType.YEAR_MONTH);
            TemporalUtil.createDataPropertyOrThrow(ctx, otherFields, TemporalConstants.DAY, 1);
            JSTemporalPlainDateObject otherDate = dateFromFieldsNode.execute(calendar, otherFields, TemporalUtil.Overflow.CONSTRAIN);
            JSTemporalDurationObject result = TemporalUtil.calendarDateUntil(ctx, realm, calendar, thisDate, otherDate, settings.largestUnit(), this, errorBranch);
            NormalizedDurationRecord duration = TemporalUtil.createNormalizedDurationRecord(result.getYears(), result.getMonths(), 0.0, 0.0, TemporalUtil.zeroTimeDuration());
            double durationYears = duration.years();
            double durationMonths = duration.months();
            boolean bl = roundingGranularityIsNoop = settings.smallestUnit() == TemporalUtil.Unit.MONTH && settings.roundingIncrement() == 1;
            if (!roundingGranularityIsNoop) {
                BigInt destEpochNs = TemporalUtil.getUTCEpochNanoseconds(otherDate.getYear(), otherDate.getMonth(), otherDate.getDay(), 0, 0, 0, 0, 0, 0);
                ISODateTimeRecord dateTime = new ISODateTimeRecord(thisDate.getYear(), thisDate.getMonth(), thisDate.getDay(), 0, 0, 0, 0, 0, 0);
                JSTemporalDurationRecord roundedDuration = roundRelativeDuration.execute(duration, destEpochNs, dateTime, calendar, null, settings.largestUnit(), settings.roundingIncrement(), settings.smallestUnit(), settings.roundingMode()).duration();
                durationYears = roundedDuration.getYears();
                durationMonths = roundedDuration.getMonths();
            }
            return JSTemporalDuration.createTemporalDuration(ctx, realm, (double)this.sign * durationYears, (double)this.sign * durationMonths, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, node, errorBranch);
        }

        @Specialization(guards={"!isJSTemporalYearMonth(thisObj)"})
        protected static Object invalidReceiver(Object thisObj, Object otherParam, Object optParam) {
            throw TemporalErrors.createTypeErrorTemporalPlainYearMonthExpected();
        }
    }

    public static abstract class JSTemporalPlainYearMonthWithNode
    extends JSTemporalBuiltinOperation {
        protected JSTemporalPlainYearMonthWithNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        protected JSTemporalPlainYearMonthObject with(JSTemporalPlainYearMonthObject yearMonth, Object temporalYearMonthLike, Object options, @Cached IsPartialTemporalObjectNode isPartialTemporalObjectNode, @Cached TemporalYearMonthFromFieldsNode yearMonthFromFieldsNode, @Cached(value="create(getJSContext())") GetOptionsObjectNode getOptionsObject, @Cached TemporalGetOptionNode getOptionNode, @Cached InlinedBranchProfile errorBranch) {
            if (!isPartialTemporalObjectNode.execute(temporalYearMonthLike)) {
                errorBranch.enter((Node)this);
                throw TemporalErrors.createTypeErrorPartialTemporalObjectExpected();
            }
            JSContext ctx = this.getContext();
            TruffleString calendar = yearMonth.getCalendar();
            JSDynamicObject fields = TemporalUtil.isoDateToFields(ctx, calendar, yearMonth.isoDate(), TemporalUtil.FieldsType.YEAR_MONTH);
            JSObject partialYearMonth = TemporalUtil.prepareCalendarFields(ctx, calendar, temporalYearMonthLike, TemporalUtil.listMMCY, TemporalUtil.listEmpty, null);
            fields = TemporalUtil.calendarMergeFields(ctx, calendar, fields, partialYearMonth);
            Object resolvedOptions = getOptionsObject.execute(options);
            TemporalUtil.Overflow overflow = TemporalUtil.getTemporalOverflowOption(resolvedOptions, getOptionNode);
            return yearMonthFromFieldsNode.execute(calendar, fields, overflow);
        }

        @Specialization(guards={"!isJSTemporalYearMonth(thisObj)"})
        protected static Object invalidReceiver(Object thisObj, Object temporalYearMonthLike, Object optParam) {
            throw TemporalErrors.createTypeErrorTemporalPlainYearMonthExpected();
        }
    }

    public static abstract class JSTemporalPlainYearMonthEqualsNode
    extends JSTemporalBuiltinOperation {
        protected JSTemporalPlainYearMonthEqualsNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        protected boolean equals(JSTemporalPlainYearMonthObject yearMonth, Object otherParam, @Cached ToTemporalCalendarIdentifierNode toCalendarIdentifier, @Cached ToTemporalYearMonthNode toTemporalYearMonthNode) {
            JSTemporalPlainYearMonthObject other = toTemporalYearMonthNode.execute(otherParam, (Object)Undefined.instance);
            if (yearMonth.getMonth() != other.getMonth()) {
                return false;
            }
            if (yearMonth.getDay() != other.getDay()) {
                return false;
            }
            if (yearMonth.getYear() != other.getYear()) {
                return false;
            }
            return TemporalUtil.calendarEquals(yearMonth.getCalendar(), other.getCalendar(), toCalendarIdentifier);
        }

        @Specialization(guards={"!isJSTemporalYearMonth(thisObj)"})
        protected static Object invalidReceiver(Object thisObj, Object otherParam) {
            throw TemporalErrors.createTypeErrorTemporalPlainYearMonthExpected();
        }
    }

    public static abstract class JSTemporalPlainYearMonthToPlainDateNode
    extends JSTemporalBuiltinOperation {
        protected JSTemporalPlainYearMonthToPlainDateNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        protected JSTemporalPlainDateObject toPlainDate(JSTemporalPlainYearMonthObject yearMonth, Object item, @Cached TemporalCalendarDateFromFieldsNode dateFromFieldsNode, @Cached InlinedBranchProfile errorBranch) {
            if (!JSRuntime.isObject(item)) {
                errorBranch.enter((Node)this);
                throw TemporalErrors.createTypeErrorTemporalPlainYearMonthExpected();
            }
            JSContext ctx = this.getContext();
            TruffleString calendar = yearMonth.getCalendar();
            JSObject fields = TemporalUtil.isoDateToFields(ctx, calendar, yearMonth.isoDate(), TemporalUtil.FieldsType.YEAR_MONTH);
            JSObject inputFields = TemporalUtil.prepareCalendarFields(ctx, calendar, item, TemporalUtil.listD, TemporalUtil.listEmpty, TemporalUtil.listEmpty);
            JSDynamicObject mergedFields = TemporalUtil.calendarMergeFields(ctx, calendar, fields, inputFields);
            return dateFromFieldsNode.execute(calendar, mergedFields, TemporalUtil.Overflow.CONSTRAIN);
        }

        @Specialization(guards={"!isJSTemporalYearMonth(thisObj)"})
        protected static Object invalidReceiver(Object thisObj, Object item) {
            throw TemporalErrors.createTypeErrorTemporalPlainYearMonthExpected();
        }
    }

    public static abstract class JSTemporalPlainYearMonthToString
    extends JSTemporalBuiltinOperation {
        protected JSTemporalPlainYearMonthToString(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        protected TruffleString toString(JSTemporalPlainYearMonthObject yearMonth, Object optParam, @Cached TruffleString.EqualNode equalNode, @Cached TemporalGetOptionNode getOptionNode, @Cached InlinedBranchProfile errorBranch, @Cached InlinedConditionProfile optionUndefined) {
            JSDynamicObject options = this.getOptionsObject(optParam, this, errorBranch, optionUndefined);
            TemporalUtil.ShowCalendar showCalendar = TemporalUtil.toShowCalendarOption(options, getOptionNode, equalNode);
            return JSTemporalPlainYearMonth.temporalYearMonthToString(yearMonth, showCalendar);
        }

        @Specialization(guards={"!isJSTemporalYearMonth(thisObj)"})
        protected static Object invalidReceiver(Object thisObj, Object optParam) {
            throw TemporalErrors.createTypeErrorTemporalPlainYearMonthExpected();
        }
    }

    public static abstract class JSTemporalPlainYearMonthToLocaleString
    extends JSTemporalBuiltinOperation {
        protected JSTemporalPlainYearMonthToLocaleString(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        protected TruffleString toLocaleString(JSTemporalPlainYearMonthObject yearMonth) {
            return JSTemporalPlainYearMonth.temporalYearMonthToString(yearMonth, TemporalUtil.ShowCalendar.AUTO);
        }

        @Specialization(guards={"!isJSTemporalYearMonth(thisObj)"})
        protected static Object invalidReceiver(Object thisObj) {
            throw TemporalErrors.createTypeErrorTemporalPlainYearMonthExpected();
        }
    }
}

