/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.compiler;

import com.oracle.graal.python.PythonLanguage;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.modules.WarningsModuleBuiltins;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.exception.PBaseException;
import com.oracle.graal.python.builtins.objects.exception.SyntaxErrorBuiltins;
import com.oracle.graal.python.builtins.objects.module.PythonModule;
import com.oracle.graal.python.lib.PyObjectCallMethodObjArgs;
import com.oracle.graal.python.nodes.BuiltinNames;
import com.oracle.graal.python.nodes.object.BuiltinClassProfiles;
import com.oracle.graal.python.pegparser.ParserCallbacks;
import com.oracle.graal.python.pegparser.tokenizer.SourceRange;
import com.oracle.graal.python.runtime.PythonContext;
import com.oracle.graal.python.runtime.exception.PException;
import com.oracle.graal.python.runtime.exception.PIncompleteSourceException;
import com.oracle.graal.python.runtime.object.PFactory;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.graal.python.util.Supplier;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleSafepoint;
import com.oracle.truffle.api.nodes.EncapsulatingNodeReference;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.source.Source;
import com.oracle.truffle.api.source.SourceSection;
import com.oracle.truffle.api.strings.TruffleString;
import java.util.ArrayList;
import java.util.List;

public class ParserCallbacksImpl
implements ParserCallbacks {
    private static final TruffleString DEFAULT_FILENAME = PythonUtils.tsLiteral("<string>");
    private final Supplier<Source> sourceSupplier;
    private final boolean withJavaStackTrace;
    private List<DeprecationWarning> deprecationWarnings;

    public ParserCallbacksImpl(Supplier<Source> sourceSupplier, boolean withJavaStackTrace) {
        this.sourceSupplier = sourceSupplier;
        this.withJavaStackTrace = withJavaStackTrace;
    }

    public ParserCallbacksImpl(Source source, boolean withJavaStackTrace) {
        this(() -> source, withJavaStackTrace);
    }

    @Override
    public void safePointPoll() {
        Node node = EncapsulatingNodeReference.getCurrent().get();
        TruffleSafepoint.poll((Node)node);
    }

    @Override
    public RuntimeException reportIncompleteSource(int line) {
        throw new PIncompleteSourceException("", null, line, (Source)this.sourceSupplier.get());
    }

    @Override
    public RuntimeException onError(ParserCallbacks.ErrorType errorType, SourceRange sourceRange, String message) {
        throw this.raiseSyntaxError(errorType, sourceRange, message);
    }

    public PException raiseSyntaxError(ParserCallbacks.ErrorType errorType, SourceRange sourceRange, String message) {
        throw ParserCallbacksImpl.raiseSyntaxError(errorType, sourceRange, PythonUtils.toTruffleStringUncached(message), (Source)this.sourceSupplier.get(), this.withJavaStackTrace);
    }

    public static PException raiseSyntaxError(ParserCallbacks.ErrorType errorType, final SourceRange sourceRange, TruffleString message, final Source source, boolean withJavaStackTrace) {
        Node location = new Node(){

            public boolean isAdoptable() {
                return false;
            }

            public SourceSection getSourceSection() {
                if (sourceRange.startLine > source.getLineCount() || sourceRange.endLine > source.getLineCount()) {
                    return source.createSection(source.getLength(), 0);
                }
                int startCol = Math.max(sourceRange.startColumn, 0) + 1;
                startCol = Math.min(startCol, source.getLineLength(sourceRange.startLine) + 1);
                int endCol = sourceRange.endColumn < 0 ? (sourceRange.startLine == sourceRange.endLine ? startCol : 1) : sourceRange.endColumn + 1;
                endCol = Math.min(endCol, source.getLineLength(sourceRange.endLine) + 1);
                if (sourceRange.endLine == source.getLineCount() && endCol == source.getLineLength(sourceRange.endLine) + 1) {
                    if (endCol > 1 && (sourceRange.startLine < sourceRange.endLine || startCol < endCol)) {
                        --endCol;
                    } else {
                        return source.createSection(source.getLength(), 0);
                    }
                }
                return source.createSection(sourceRange.startLine, startCol, sourceRange.endLine, endCol);
            }
        };
        PythonBuiltinClassType cls = PythonBuiltinClassType.SyntaxError;
        switch (errorType) {
            case System: {
                cls = PythonBuiltinClassType.SystemError;
                break;
            }
            case Indentation: {
                cls = PythonBuiltinClassType.IndentationError;
                break;
            }
            case Tab: {
                cls = PythonBuiltinClassType.TabError;
            }
        }
        PBaseException instance = PFactory.createBaseException(PythonLanguage.get(null), cls, message, PythonUtils.EMPTY_OBJECT_ARRAY);
        Object[] excAttrs = SyntaxErrorBuiltins.SYNTAX_ERROR_ATTR_FACTORY.create();
        TruffleString filename = ParserCallbacksImpl.getFilename(source);
        excAttrs[1] = filename;
        excAttrs[2] = sourceRange.startLine;
        excAttrs[3] = sourceRange.startColumn + 1;
        excAttrs[5] = sourceRange.endLine == -1 ? PNone.NONE : Integer.valueOf(sourceRange.endLine);
        excAttrs[6] = sourceRange.endColumn == -1 ? PNone.NONE : Integer.valueOf(sourceRange.endColumn + 1);
        PNone text = PNone.NONE;
        if (source.hasCharacters() && sourceRange.startLine <= source.getLineCount()) {
            String lineText = source.getCharacters(sourceRange.startLine).toString();
            if (lineText.startsWith("\ufeff")) {
                lineText = lineText.substring(1);
            }
            text = PythonUtils.toTruffleStringUncached(lineText);
        }
        excAttrs[0] = message;
        excAttrs[4] = text;
        instance.setExceptionAttributes(excAttrs);
        throw PException.fromObject((Object)instance, location, withJavaStackTrace);
    }

    private static TruffleString getFilename(Source source) {
        TruffleString filename = PythonUtils.toTruffleStringUncached(source.getPath());
        if (filename == null && (filename = PythonUtils.toTruffleStringUncached(source.getName())) == null) {
            filename = DEFAULT_FILENAME;
        }
        return filename;
    }

    @Override
    public void onWarning(ParserCallbacks.WarningType warningType, SourceRange sourceRange, String message) {
        if (this.deprecationWarnings == null) {
            this.deprecationWarnings = new ArrayList<DeprecationWarning>();
        }
        this.deprecationWarnings.add(new DeprecationWarning(switch (warningType) {
            case ParserCallbacks.WarningType.Deprecation -> PythonBuiltinClassType.DeprecationWarning;
            case ParserCallbacks.WarningType.Syntax -> PythonBuiltinClassType.SyntaxWarning;
            default -> throw CompilerDirectives.shouldNotReachHere((String)("Unexpected warning type: " + String.valueOf((Object)warningType)));
        }, sourceRange, PythonUtils.toTruffleStringUncached(message)));
    }

    public void triggerDeprecationWarnings() {
        if (this.deprecationWarnings != null) {
            this.triggerDeprecationWarningsBoundary();
        }
    }

    public void triggerAndClearDeprecationWarnings() {
        if (this.deprecationWarnings != null) {
            this.triggerDeprecationWarningsBoundary();
            this.deprecationWarnings.clear();
        }
    }

    @CompilerDirectives.TruffleBoundary
    private void triggerDeprecationWarningsBoundary() {
        PythonModule warnings = PythonContext.get(null).lookupBuiltinModule(BuiltinNames.T__WARNINGS);
        Source source = (Source)this.sourceSupplier.get();
        for (DeprecationWarning warning : this.deprecationWarnings) {
            try {
                PyObjectCallMethodObjArgs.executeUncached(warnings, WarningsModuleBuiltins.T_WARN_EXPLICIT, new Object[]{warning.message, warning.type, ParserCallbacksImpl.getFilename(source), warning.sourceRange.startLine});
            }
            catch (PException e) {
                e.expect(null, warning.type, BuiltinClassProfiles.IsBuiltinObjectProfile.getUncached());
                throw ParserCallbacksImpl.raiseSyntaxError(ParserCallbacks.ErrorType.Syntax, warning.sourceRange, warning.message, source, this.withJavaStackTrace);
            }
        }
    }

    private static class DeprecationWarning {
        final PythonBuiltinClassType type;
        final SourceRange sourceRange;
        final TruffleString message;

        public DeprecationWarning(PythonBuiltinClassType type, SourceRange sourceRange, TruffleString message) {
            this.type = type;
            this.sourceRange = sourceRange;
            this.message = message;
        }
    }
}

