/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.random;

import com.oracle.graal.python.builtins.objects.object.PythonBuiltinObject;
import com.oracle.truffle.api.object.Shape;

public class PRandom
extends PythonBuiltinObject {
    public static final int N = 624;
    private static final int M = 397;
    private static final int UPPER_MASK = Integer.MIN_VALUE;
    private static final int LOWER_MASK = Integer.MAX_VALUE;
    private static final int[] MAG01 = new int[]{0, -1727483681};
    private int[] state = new int[624];
    private int index;

    public PRandom(Object cls, Shape instanceShape) {
        super(cls, instanceShape);
    }

    void seed(int[] seed) {
        int k;
        int[] mt = this.state;
        mt[0] = 19650218;
        for (int mti = 1; mti < 624; ++mti) {
            mt[mti] = 1812433253 * (mt[mti - 1] ^ mt[mti - 1] >>> 30) + mti;
        }
        this.index = 624;
        int i = 1;
        int j = 0;
        int keyLength = seed.length;
        int n = k = 624 > keyLength ? 624 : keyLength;
        while (k != 0) {
            mt[i] = (mt[i] ^ (mt[i - 1] ^ mt[i - 1] >>> 30) * 1664525) + seed[j] + j;
            ++j;
            if (++i >= 624) {
                mt[0] = mt[623];
                i = 1;
            }
            if (j >= keyLength) {
                j = 0;
            }
            --k;
        }
        for (k = 623; k != 0; --k) {
            mt[i] = (mt[i] ^ (mt[i - 1] ^ mt[i - 1] >>> 30) * 1566083941) - i;
            if (++i < 624) continue;
            mt[0] = mt[623];
            i = 1;
        }
        mt[0] = Integer.MIN_VALUE;
    }

    int nextInt() {
        int[] mt = this.state;
        if (this.index >= 624) {
            int y;
            int kk;
            for (kk = 0; kk < 227; ++kk) {
                y = mt[kk] & Integer.MIN_VALUE | mt[kk + 1] & Integer.MAX_VALUE;
                mt[kk] = mt[kk + 397] ^ y >>> 1 ^ MAG01[y & 1];
            }
            while (kk < 623) {
                y = mt[kk] & Integer.MIN_VALUE | mt[kk + 1] & Integer.MAX_VALUE;
                mt[kk] = mt[kk + -227] ^ y >>> 1 ^ MAG01[y & 1];
                ++kk;
            }
            y = mt[623] & Integer.MIN_VALUE | mt[0] & Integer.MAX_VALUE;
            mt[623] = mt[396] ^ y >>> 1 ^ MAG01[y & 1];
            this.index = 0;
        }
        int y = mt[this.index++];
        y ^= y >>> 11;
        y ^= y << 7 & 0x9D2C5680;
        y ^= y << 15 & 0xEFC60000;
        y ^= y >>> 18;
        return y;
    }

    double nextDouble() {
        int a = this.nextInt() >>> 5;
        int b = this.nextInt() >>> 6;
        return ((double)a * 6.7108864E7 + (double)b) * (double)1.110223E-16f;
    }

    int[] getState() {
        return this.state;
    }

    int getIndex() {
        return this.index;
    }

    void restore(int[] new_state, int new_index) {
        assert (new_state.length == 624);
        assert (new_index >= 0 && new_index <= 624);
        this.state = new_state;
        this.index = new_index;
    }
}

