/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.opensearch.planner.rules;

import java.util.function.Predicate;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Sort;
import org.apache.calcite.rel.logical.LogicalSort;
import org.immutables.value.Value;
import org.opensearch.sql.calcite.plan.rule.OpenSearchRuleConfig;
import org.opensearch.sql.calcite.utils.PlanUtils;
import org.opensearch.sql.opensearch.planner.rules.ImmutableSortAggregateMeasureRule;
import org.opensearch.sql.opensearch.planner.rules.InterruptibleRelRule;
import org.opensearch.sql.opensearch.storage.scan.AbstractCalciteIndexScan;
import org.opensearch.sql.opensearch.storage.scan.CalciteLogicalIndexScan;

@Value.Enclosing
public class SortAggregateMeasureRule
extends InterruptibleRelRule<Config> {
    protected SortAggregateMeasureRule(Config config) {
        super(config);
    }

    @Override
    protected void onMatchImpl(RelOptRuleCall call) {
        LogicalSort sort = (LogicalSort)call.rel(0);
        CalciteLogicalIndexScan scan = (CalciteLogicalIndexScan)call.rel(1);
        CalciteLogicalIndexScan newScan = scan.pushDownSortAggregateMeasure((Sort)sort);
        if (newScan != null) {
            call.transformTo((RelNode)newScan);
            PlanUtils.tryPruneRelNodes((RelOptRuleCall)call);
        }
    }

    @Value.Immutable
    public static interface Config
    extends OpenSearchRuleConfig {
        public static final Predicate<Sort> hasOneFieldCollation = sort -> sort.getCollation().getFieldCollations().size() == 1;
        public static final Config DEFAULT = ImmutableSortAggregateMeasureRule.Config.builder().build().withDescription("Sort-TableScan(agg-pushed)").withOperandSupplier(b0 -> b0.operand(LogicalSort.class).predicate(hasOneFieldCollation.and(PlanUtils::sortByFieldsOnly)).oneInput(b1 -> b1.operand(CalciteLogicalIndexScan.class).predicate(Predicate.not(AbstractCalciteIndexScan::noAggregatePushed)).noInputs()));

        default public SortAggregateMeasureRule toRule() {
            return new SortAggregateMeasureRule(this);
        }
    }
}

