/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.security.rest;

import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.util.List;
import org.opensearch.common.settings.Settings;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.rest.BaseRestHandler;
import org.opensearch.rest.BytesRestResponse;
import org.opensearch.rest.RestChannel;
import org.opensearch.rest.RestController;
import org.opensearch.rest.RestHandler;
import org.opensearch.rest.RestRequest;
import org.opensearch.rest.RestResponse;
import org.opensearch.security.auth.BackendRegistry;
import org.opensearch.security.dlic.rest.support.Utils;
import org.opensearch.security.privileges.PrivilegesConfiguration;
import org.opensearch.security.privileges.PrivilegesEvaluator;
import org.opensearch.security.support.SecuritySettings;
import org.opensearch.transport.client.node.NodeClient;

public class SecurityHealthAction
extends BaseRestHandler {
    private static final List<RestHandler.Route> routes = Utils.addRoutesPrefix((List<RestHandler.Route>)ImmutableList.of((Object)new RestHandler.Route(RestRequest.Method.GET, "/health"), (Object)new RestHandler.Route(RestRequest.Method.POST, "/health")), "/_plugins/_security");
    private static final List<RestHandler.DeprecatedRoute> deprecatedRoutes = Utils.addDeprecatedRoutesPrefix((List<RestHandler.DeprecatedRoute>)ImmutableList.of((Object)new RestHandler.DeprecatedRoute(RestRequest.Method.GET, "/health", "[_opendistro/_security] is a deprecated endpoint path. Please use _plugins/_security instead."), (Object)new RestHandler.DeprecatedRoute(RestRequest.Method.POST, "/health", "[_opendistro/_security] is a deprecated endpoint path. Please use _plugins/_security instead.")), "/_opendistro/_security");
    private final BackendRegistry registry;
    private final PrivilegesConfiguration privilegesConfiguration;

    public SecurityHealthAction(Settings settings, RestController controller, BackendRegistry registry, PrivilegesConfiguration privilegesConfiguration) {
        this.registry = registry;
        this.privilegesConfiguration = privilegesConfiguration;
    }

    public List<RestHandler.Route> routes() {
        return routes;
    }

    public List<RestHandler.DeprecatedRoute> deprecatedRoutes() {
        return deprecatedRoutes;
    }

    protected BaseRestHandler.RestChannelConsumer prepareRequest(final RestRequest request, NodeClient client) throws IOException {
        return new BaseRestHandler.RestChannelConsumer(){
            final String mode;
            {
                this.mode = request.param("mode", "strict");
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void accept(RestChannel channel) throws Exception {
                XContentBuilder builder = channel.newBuilder();
                RestStatus restStatus = RestStatus.OK;
                BytesRestResponse response = null;
                try {
                    String status = "UP";
                    String message = null;
                    builder.startObject();
                    if ("strict".equalsIgnoreCase(this.mode) && (!SecurityHealthAction.this.registry.isInitialized() || SecurityHealthAction.this.privilegesConfiguration.privilegesEvaluator().type() == PrivilegesEvaluator.PrivilegesEvaluatorType.NOT_INITIALIZED)) {
                        status = "DOWN";
                        message = "Not initialized";
                        restStatus = RestStatus.SERVICE_UNAVAILABLE;
                    }
                    builder.field("message", message);
                    builder.field("mode", this.mode);
                    builder.field("status", status);
                    builder.startObject("settings");
                    builder.field(SecuritySettings.CACHE_TTL_SETTING.getKey(), SecurityHealthAction.this.registry.getTtlInMin());
                    builder.endObject();
                    builder.endObject();
                    response = new BytesRestResponse(restStatus, builder);
                }
                finally {
                    builder.close();
                }
                channel.sendResponse((RestResponse)response);
            }
        };
    }

    public String getName() {
        return "OpenSearch Security Health Check";
    }
}

