/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ec2.Ec2Client;
import software.amazon.awssdk.services.ec2.internal.UserAgentUtils;
import software.amazon.awssdk.services.ec2.model.DescribeLocalGatewayRouteTablesRequest;
import software.amazon.awssdk.services.ec2.model.DescribeLocalGatewayRouteTablesResponse;
import software.amazon.awssdk.services.ec2.model.LocalGatewayRouteTable;

public class DescribeLocalGatewayRouteTablesIterable
implements SdkIterable<DescribeLocalGatewayRouteTablesResponse> {
    private final Ec2Client client;
    private final DescribeLocalGatewayRouteTablesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeLocalGatewayRouteTablesIterable(Ec2Client client, DescribeLocalGatewayRouteTablesRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new DescribeLocalGatewayRouteTablesResponseFetcher();
    }

    public Iterator<DescribeLocalGatewayRouteTablesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<LocalGatewayRouteTable> localGatewayRouteTables() {
        Function<DescribeLocalGatewayRouteTablesResponse, Iterator> getIterator = response -> {
            if (response != null && response.localGatewayRouteTables() != null) {
                return response.localGatewayRouteTables().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class DescribeLocalGatewayRouteTablesResponseFetcher
    implements SyncPageFetcher<DescribeLocalGatewayRouteTablesResponse> {
        private DescribeLocalGatewayRouteTablesResponseFetcher() {
        }

        public boolean hasNextPage(DescribeLocalGatewayRouteTablesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public DescribeLocalGatewayRouteTablesResponse nextPage(DescribeLocalGatewayRouteTablesResponse previousPage) {
            if (previousPage == null) {
                return DescribeLocalGatewayRouteTablesIterable.this.client.describeLocalGatewayRouteTables(DescribeLocalGatewayRouteTablesIterable.this.firstRequest);
            }
            return DescribeLocalGatewayRouteTablesIterable.this.client.describeLocalGatewayRouteTables((DescribeLocalGatewayRouteTablesRequest)((Object)DescribeLocalGatewayRouteTablesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

