"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getAnomalyDetectionUiSettings = getAnomalyDetectionUiSettings;
var _configSchema = require("@osd/config-schema");
var _i18n = require("@osd/i18n");
var _constants = require("../utils/constants");
/*
 * SPDX-License-Identifier: Apache-2.0
 *
 * The OpenSearch Contributors require contributions made to
 * this file be licensed under the Apache-2.0 license or a
 * compatible open source license.
 *
 * Modifications Copyright OpenSearch Contributors. See
 * GitHub history for details.
 */

/**
 * UI settings for Detection Insights
 */
function getAnomalyDetectionUiSettings() {
  return {
    [_constants.DAILY_INSIGHTS_ENABLED]: {
      name: _i18n.i18n.translate('anomalyDetection.uiSettings.dailyInsightsEnabled.title', {
        defaultMessage: 'Enable Daily Insights'
      }),
      value: false,
      description: _i18n.i18n.translate('anomalyDetection.uiSettings.dailyInsightsEnabled.description', {
        defaultMessage: 'Enable or disable the Daily Insights feature. Daily Insights uses algorithms to analyze and summarize correlated anomalies across your detectors. Note: The backend cluster setting "plugins.anomaly_detection.insights_enabled" must also be enabled.'
      }),
      category: ['Detection Insights'],
      schema: _configSchema.schema.boolean(),
      requiresPageReload: true
    }
  };
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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