/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.timeseries;

import java.util.Locale;
import org.opensearch.timeseries.model.InitProgressProfile;

public abstract class AbstractProfileRunner {
    protected long requiredSamples;

    public AbstractProfileRunner(long requiredSamples) {
        this.requiredSamples = requiredSamples;
    }

    protected InitProgressProfile computeInitProgressProfile(long totalUpdates, long intervalMins) {
        float percent = Math.min(100.0f * (float)totalUpdates / (float)this.requiredSamples, 100.0f);
        int neededPoints = (int)(this.requiredSamples - totalUpdates);
        return new InitProgressProfile(String.format(Locale.ROOT, "%.0f%%", Float.valueOf(percent)), intervalMins * (long)neededPoints, neededPoints);
    }
}

