/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.protocol.oid4vc.issuance;

import jakarta.ws.rs.core.UriBuilder;
import java.net.URI;
import org.jboss.logging.Logger;
import org.keycloak.http.HttpResponse;
import org.keycloak.jose.jwk.JSONWebKeySet;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakUriInfo;
import org.keycloak.models.RealmModel;
import org.keycloak.protocol.oid4vc.model.JWTVCIssuerMetadata;
import org.keycloak.protocol.oidc.utils.JWKSServerUtils;
import org.keycloak.services.Urls;
import org.keycloak.services.resources.ServerMetadataResource;
import org.keycloak.urls.UrlType;
import org.keycloak.wellknown.WellKnownProvider;

public class JWTVCIssuerWellKnownProvider
implements WellKnownProvider {
    private static final Logger LOGGER = Logger.getLogger(JWTVCIssuerWellKnownProvider.class);
    private final KeycloakSession session;

    public JWTVCIssuerWellKnownProvider(KeycloakSession session) {
        this.session = session;
    }

    public void close() {
    }

    @Override
    public Object getConfig() {
        KeycloakUriInfo frontendUriInfo = this.session.getContext().getUri(UrlType.FRONTEND);
        RealmModel realm = this.session.getContext().getRealm();
        this.addDeprecationHeadersIfOldRoute();
        JWTVCIssuerMetadata config = new JWTVCIssuerMetadata();
        config.setIssuer(Urls.realmIssuer(frontendUriInfo.getBaseUri(), realm.getName()));
        JSONWebKeySet jwks = JWKSServerUtils.getRealmJwks(this.session, realm);
        config.setJwks(jwks);
        return config;
    }

    private void addDeprecationHeadersIfOldRoute() {
        boolean isOldRoute;
        String requestPath = this.session.getContext().getUri().getRequestUri().getPath();
        if (requestPath == null) {
            return;
        }
        int idxRealms = requestPath.indexOf("/realms/");
        int idxWellKnown = requestPath.indexOf("/.well-known/");
        boolean bl = isOldRoute = idxRealms >= 0 && idxWellKnown > idxRealms;
        if (!isOldRoute) {
            return;
        }
        RealmModel realm = this.session.getContext().getRealm();
        if (realm == null) {
            return;
        }
        UriBuilder base = this.session.getContext().getUri().getBaseUriBuilder();
        URI successor = ServerMetadataResource.wellKnownOAuthProviderUrl(base).build(new Object[]{"jwt-vc-issuer", realm.getName()});
        HttpResponse httpResponse = this.session.getContext().getHttpResponse();
        httpResponse.setHeader("Warning", "299 - \"Deprecated endpoint; use " + String.valueOf(successor) + "\"");
        httpResponse.setHeader("Deprecation", "true");
        httpResponse.setHeader("Link", "<" + String.valueOf(successor) + ">; rel=\"successor-version\"");
        LOGGER.warnf("Deprecated realm-scoped well-known endpoint accessed for JWT VC issuer in realm '%s'. Use %s instead.", (Object)realm.getName(), (Object)successor);
    }
}

