/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.event.spi;

import org.hibernate.LockMode;
import org.hibernate.LockOptions;
import org.hibernate.Locking;
import org.hibernate.event.spi.AbstractEvent;
import org.hibernate.event.spi.EventSource;

public class LockEvent
extends AbstractEvent {
    public static final String ILLEGAL_SKIP_LOCKED = "Skip-locked is not valid option for #lock";
    private Object object;
    private final LockOptions lockOptions;
    private String entityName;

    public LockEvent(String entityName, Object object, LockOptions lockOptions, EventSource source) {
        super(source);
        if (object == null) {
            throw new IllegalArgumentException("Entity may not be null");
        }
        if (lockOptions == null) {
            throw new IllegalArgumentException("LockOptions may not be null");
        }
        if (lockOptions.getLockMode() == LockMode.UPGRADE_SKIPLOCKED || lockOptions.getTimeout().milliseconds() == -2) {
            throw new IllegalArgumentException(ILLEGAL_SKIP_LOCKED);
        }
        this.entityName = entityName;
        this.object = object;
        this.lockOptions = lockOptions;
    }

    public LockEvent(Object object, LockOptions lockOptions, EventSource source) {
        this(null, object, lockOptions, source);
    }

    @Deprecated(since="7", forRemoval=true)
    public LockEvent(Object object, LockMode lockMode, EventSource source) {
        this(object, lockMode.toLockOptions(), source);
    }

    @Deprecated(since="7", forRemoval=true)
    public LockEvent(String entityName, Object object, LockMode lockMode, EventSource source) {
        this(entityName, object, lockMode.toLockOptions(), source);
    }

    public Object getObject() {
        return this.object;
    }

    public void setObject(Object object) {
        this.object = object;
    }

    public LockOptions getLockOptions() {
        return this.lockOptions;
    }

    public String getEntityName() {
        return this.entityName;
    }

    public void setEntityName(String entityName) {
        this.entityName = entityName;
    }

    @Deprecated(since="7.1")
    public LockMode getLockMode() {
        return this.lockOptions.getLockMode();
    }

    @Deprecated(since="7.1")
    public int getLockTimeout() {
        return this.lockOptions.getTimeOut();
    }

    @Deprecated(since="7.1")
    public boolean getLockScope() {
        return this.lockOptions.getScope() != Locking.Scope.ROOT_ONLY;
    }
}

