/*
 * Decompiled with CFR 0.152.
 */
package sun.security.krb5.internal.crypto.dk;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.security.GeneralSecurityException;
import java.util.Arrays;
import javax.crypto.Cipher;
import sun.misc.HexDumpEncoder;
import sun.security.krb5.Confounder;
import sun.security.krb5.KrbCryptoException;
import sun.security.krb5.internal.crypto.KeyUsage;

public abstract class DkCrypto {
    protected static final boolean debug = false;
    static final byte[] KERBEROS_CONSTANT = new byte[]{107, 101, 114, 98, 101, 114, 111, 115};

    protected abstract int getKeySeedLength();

    protected abstract byte[] randomToKey(byte[] var1);

    protected abstract Cipher getCipher(byte[] var1, byte[] var2, int var3) throws GeneralSecurityException;

    public abstract int getChecksumLength();

    protected abstract byte[] getHmac(byte[] var1, byte[] var2) throws GeneralSecurityException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] encrypt(byte[] byArray, int n, byte[] byArray2, byte[] byArray3, byte[] byArray4, int n2, int n3) throws GeneralSecurityException, KrbCryptoException {
        byte[] byArray5;
        byte[] byArray6;
        block7: {
            if (!KeyUsage.isValid(n)) {
                throw new GeneralSecurityException("Invalid key usage number: " + n);
            }
            byte[] byArray7 = null;
            byArray6 = null;
            try {
                byte[] byArray8 = new byte[]{(byte)(n >> 24 & 0xFF), (byte)(n >> 16 & 0xFF), (byte)(n >> 8 & 0xFF), (byte)(n & 0xFF), -86};
                byArray7 = this.dk(byArray, byArray8);
                Cipher cipher = this.getCipher(byArray7, byArray2, 1);
                int n4 = cipher.getBlockSize();
                byte[] byArray9 = Confounder.bytes(n4);
                int n5 = this.roundup(byArray9.length + n3, n4);
                byte[] byArray10 = new byte[n5];
                System.arraycopy(byArray9, 0, byArray10, 0, byArray9.length);
                System.arraycopy(byArray4, n2, byArray10, byArray9.length, n3);
                Arrays.fill(byArray10, byArray9.length + n3, n5, (byte)0);
                int n6 = cipher.getOutputSize(n5);
                int n7 = n6 + this.getChecksumLength();
                byte[] byArray11 = new byte[n7];
                cipher.doFinal(byArray10, 0, n5, byArray11, 0);
                if (byArray3 != null && byArray3.length == n4) {
                    System.arraycopy(byArray11, n6 - n4, byArray3, 0, n4);
                }
                byArray8[4] = 85;
                byArray6 = this.dk(byArray, byArray8);
                byte[] byArray12 = this.getHmac(byArray6, byArray10);
                System.arraycopy(byArray12, 0, byArray11, n6, this.getChecksumLength());
                byArray5 = byArray11;
                if (byArray7 == null) break block7;
            }
            catch (Throwable throwable) {
                if (byArray7 != null) {
                    Arrays.fill(byArray7, 0, byArray7.length, (byte)0);
                }
                if (byArray6 != null) {
                    Arrays.fill(byArray6, 0, byArray6.length, (byte)0);
                }
                throw throwable;
            }
            Arrays.fill(byArray7, 0, byArray7.length, (byte)0);
        }
        if (byArray6 != null) {
            Arrays.fill(byArray6, 0, byArray6.length, (byte)0);
        }
        return byArray5;
    }

    public byte[] encryptRaw(byte[] byArray, int n, byte[] byArray2, byte[] byArray3, int n2, int n3) throws GeneralSecurityException, KrbCryptoException {
        Cipher cipher = this.getCipher(byArray, byArray2, 1);
        int n4 = cipher.getBlockSize();
        if (n3 % n4 != 0) {
            throw new GeneralSecurityException("length of data to be encrypted (" + n3 + ") is not a multiple of the blocksize (" + n4 + ")");
        }
        int n5 = cipher.getOutputSize(n3);
        byte[] byArray4 = new byte[n5];
        cipher.doFinal(byArray3, 0, n3, byArray4, 0);
        return byArray4;
    }

    public byte[] decryptRaw(byte[] byArray, int n, byte[] byArray2, byte[] byArray3, int n2, int n3) throws GeneralSecurityException {
        Cipher cipher = this.getCipher(byArray, byArray2, 2);
        int n4 = cipher.getBlockSize();
        if (n3 % n4 != 0) {
            throw new GeneralSecurityException("length of data to be decrypted (" + n3 + ") is not a multiple of the blocksize (" + n4 + ")");
        }
        byte[] byArray4 = cipher.doFinal(byArray3, n2, n3);
        return byArray4;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] decrypt(byte[] byArray, int n, byte[] byArray2, byte[] byArray3, int n2, int n3) throws GeneralSecurityException {
        byte[] byArray4;
        byte[] byArray5;
        block10: {
            if (!KeyUsage.isValid(n)) {
                throw new GeneralSecurityException("Invalid key usage number: " + n);
            }
            byte[] byArray6 = null;
            byArray5 = null;
            try {
                byte[] byArray7 = new byte[]{(byte)(n >> 24 & 0xFF), (byte)(n >> 16 & 0xFF), (byte)(n >> 8 & 0xFF), (byte)(n & 0xFF), -86};
                byArray6 = this.dk(byArray, byArray7);
                Cipher cipher = this.getCipher(byArray6, byArray2, 2);
                int n4 = cipher.getBlockSize();
                int n5 = this.getChecksumLength();
                int n6 = n3 - n5;
                byte[] byArray8 = cipher.doFinal(byArray3, n2, n6);
                byArray7[4] = 85;
                byArray5 = this.dk(byArray, byArray7);
                byte[] byArray9 = this.getHmac(byArray5, byArray8);
                boolean bl = false;
                if (byArray9.length >= n5) {
                    for (int i = 0; i < n5; ++i) {
                        if (byArray9[i] == byArray3[n6 + i]) continue;
                        bl = true;
                        break;
                    }
                }
                if (bl) {
                    throw new GeneralSecurityException("Checksum failed");
                }
                if (byArray2 != null && byArray2.length == n4) {
                    System.arraycopy(byArray3, n2 + n6 - n4, byArray2, 0, n4);
                }
                byte[] byArray10 = new byte[byArray8.length - n4];
                System.arraycopy(byArray8, n4, byArray10, 0, byArray10.length);
                byArray4 = byArray10;
                if (byArray6 == null) break block10;
            }
            catch (Throwable throwable) {
                if (byArray6 != null) {
                    Arrays.fill(byArray6, 0, byArray6.length, (byte)0);
                }
                if (byArray5 != null) {
                    Arrays.fill(byArray5, 0, byArray5.length, (byte)0);
                }
                throw throwable;
            }
            Arrays.fill(byArray6, 0, byArray6.length, (byte)0);
        }
        if (byArray5 != null) {
            Arrays.fill(byArray5, 0, byArray5.length, (byte)0);
        }
        return byArray4;
    }

    int roundup(int n, int n2) {
        return (n + n2 - 1) / n2 * n2;
    }

    public byte[] calculateChecksum(byte[] byArray, int n, byte[] byArray2, int n2, int n3) throws GeneralSecurityException {
        if (!KeyUsage.isValid(n)) {
            throw new GeneralSecurityException("Invalid key usage number: " + n);
        }
        byte[] byArray3 = new byte[]{(byte)(n >> 24 & 0xFF), (byte)(n >> 16 & 0xFF), (byte)(n >> 8 & 0xFF), (byte)(n & 0xFF), -103};
        byte[] byArray4 = this.dk(byArray, byArray3);
        try {
            byte[] byArray5 = this.getHmac(byArray4, byArray2);
            if (byArray5.length == this.getChecksumLength()) {
                byte[] byArray6 = byArray5;
                return byArray6;
            }
            if (byArray5.length > this.getChecksumLength()) {
                byte[] byArray7 = new byte[this.getChecksumLength()];
                System.arraycopy(byArray5, 0, byArray7, 0, byArray7.length);
                byte[] byArray8 = byArray7;
                return byArray8;
            }
            throw new GeneralSecurityException("checksum size too short: " + byArray5.length + "; expecting : " + this.getChecksumLength());
        }
        finally {
            Arrays.fill(byArray4, 0, byArray4.length, (byte)0);
        }
    }

    byte[] dk(byte[] byArray, byte[] byArray2) throws GeneralSecurityException {
        return this.randomToKey(this.dr(byArray, byArray2));
    }

    private byte[] dr(byte[] byArray, byte[] byArray2) throws GeneralSecurityException {
        int n;
        Cipher cipher = this.getCipher(byArray, null, 1);
        int n2 = cipher.getBlockSize();
        if (byArray2.length != n2) {
            byArray2 = DkCrypto.nfold(byArray2, n2 * 8);
        }
        byte[] byArray3 = byArray2;
        int n3 = this.getKeySeedLength() >> 3;
        byte[] byArray4 = new byte[n3];
        boolean bl = false;
        for (int i = 0; i < n3; i += n) {
            byte[] byArray5 = cipher.doFinal(byArray3);
            n = n3 - i <= byArray5.length ? n3 - i : byArray5.length;
            System.arraycopy(byArray5, 0, byArray4, i, n);
            byArray3 = byArray5;
        }
        return byArray4;
    }

    static byte[] nfold(byte[] byArray, int n) {
        int n2;
        int n3 = byArray.length;
        int n4 = n >>= 3;
        int n5 = n3;
        while (n5 != 0) {
            int n6 = n5;
            n5 = n4 % n5;
            n4 = n6;
        }
        int n7 = n * n3 / n4;
        byte[] byArray2 = new byte[n];
        Arrays.fill(byArray2, (byte)0);
        int n8 = 0;
        for (n2 = n7 - 1; n2 >= 0; --n2) {
            int n9 = ((n3 << 3) - 1 + ((n3 << 3) + 13) * (n2 / n3) + (n3 - n2 % n3 << 3)) % (n3 << 3);
            int n10 = ((byArray[(n3 - 1 - (n9 >>> 3)) % n3] & 0xFF) << 8 | byArray[(n3 - (n9 >>> 3)) % n3] & 0xFF) >>> (n9 & 7) + 1 & 0xFF;
            n8 += n10;
            int n11 = byArray2[n2 % n] & 0xFF;
            byArray2[n2 % n] = (byte)((n8 += n11) & 0xFF);
            n8 >>>= 8;
        }
        if (n8 != 0) {
            for (n2 = n - 1; n2 >= 0; --n2) {
                byArray2[n2] = (byte)((n8 += byArray2[n2] & 0xFF) & 0xFF);
                n8 >>>= 8;
            }
        }
        return byArray2;
    }

    static String bytesToString(byte[] byArray) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < byArray.length; ++i) {
            if ((byArray[i] & 0xFF) < 16) {
                stringBuffer.append("0" + Integer.toHexString(byArray[i] & 0xFF));
                continue;
            }
            stringBuffer.append(Integer.toHexString(byArray[i] & 0xFF));
        }
        return stringBuffer.toString();
    }

    private static byte[] binaryStringToBytes(String string) {
        char[] cArray = string.toCharArray();
        byte[] byArray = new byte[cArray.length / 2];
        for (int i = 0; i < byArray.length; ++i) {
            byte by = Byte.parseByte(new String(cArray, i * 2, 1), 16);
            byte by2 = Byte.parseByte(new String(cArray, i * 2 + 1, 1), 16);
            byArray[i] = (byte)(by << 4 | by2);
        }
        return byArray;
    }

    static void traceOutput(String string, byte[] byArray, int n, int n2) {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(n2);
            new HexDumpEncoder().encodeBuffer(new ByteArrayInputStream(byArray, n, n2), (OutputStream)byteArrayOutputStream);
            System.err.println(string + ":" + byteArrayOutputStream.toString());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    static byte[] charToUtf8(char[] cArray) {
        Charset charset = Charset.forName("UTF-8");
        CharBuffer charBuffer = CharBuffer.wrap(cArray);
        ByteBuffer byteBuffer = charset.encode(charBuffer);
        int n = byteBuffer.limit();
        byte[] byArray = new byte[n];
        byteBuffer.get(byArray, 0, n);
        return byArray;
    }

    static byte[] charToUtf16(char[] cArray) {
        Charset charset = Charset.forName("UTF-16LE");
        CharBuffer charBuffer = CharBuffer.wrap(cArray);
        ByteBuffer byteBuffer = charset.encode(charBuffer);
        int n = byteBuffer.limit();
        byte[] byArray = new byte[n];
        byteBuffer.get(byArray, 0, n);
        return byArray;
    }
}

