/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.formatter;

import com.intellij.formatting.Block;
import com.intellij.formatting.FormattingModel;
import com.intellij.formatting.FormattingModelBuilder;
import com.intellij.formatting.Indent;
import com.intellij.lang.ASTNode;
import com.intellij.lang.FileASTNode;
import com.intellij.lang.Language;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiRecursiveElementVisitor;
import com.intellij.psi.TokenType;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.formatter.DocumentBasedFormattingModel;
import com.intellij.psi.formatter.FormatterUtil;
import com.intellij.psi.formatter.FormattingDocumentModelImpl;
import com.intellij.psi.formatter.PsiBasedFormattingModel;
import com.intellij.psi.impl.source.tree.TreeUtil;
import com.intellij.psi.tree.IElementType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.GroovyLanguage;
import org.jetbrains.plugins.groovy.codeStyle.GroovyCodeStyleSettings;
import org.jetbrains.plugins.groovy.formatter.AlignmentProvider;
import org.jetbrains.plugins.groovy.formatter.FormattingContext;
import org.jetbrains.plugins.groovy.formatter.GeeseUtil;
import org.jetbrains.plugins.groovy.formatter.GroovyBlockProducer;
import org.jetbrains.plugins.groovy.formatter.blocks.GroovyBlock;
import org.jetbrains.plugins.groovy.lang.psi.impl.PsiImplUtil;

public final class GroovyFormattingModelBuilder
implements FormattingModelBuilder {
    @NotNull
    public FormattingModel createModel(@NotNull com.intellij.formatting.FormattingContext formattingContext) {
        if (formattingContext == null) {
            GroovyFormattingModelBuilder.$$$reportNull$$$0(0);
        }
        PsiFile containingFile = formattingContext.getContainingFile().getViewProvider().getPsi((Language)GroovyLanguage.INSTANCE);
        assert (containingFile != null);
        FileASTNode astNode = containingFile.getNode();
        assert (astNode != null);
        CodeStyleSettings settings = formattingContext.getCodeStyleSettings();
        CommonCodeStyleSettings groovySettings = settings.getCommonSettings((Language)GroovyLanguage.INSTANCE);
        GroovyCodeStyleSettings customSettings = (GroovyCodeStyleSettings)settings.getCustomSettings(GroovyCodeStyleSettings.class);
        final AlignmentProvider alignments = new AlignmentProvider();
        if (customSettings.USE_FLYING_GEESE_BRACES) {
            formattingContext.getPsiElement().accept((PsiElementVisitor)new PsiRecursiveElementVisitor(){

                public void visitElement(@NotNull PsiElement element) {
                    if (element == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (GeeseUtil.isClosureRBrace(element)) {
                        GeeseUtil.calculateRBraceAlignment(element, alignments);
                    } else {
                        super.visitElement(element);
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/plugins/groovy/formatter/GroovyFormattingModelBuilder$1", "visitElement"));
                }
            });
        }
        GroovyBlock block = new GroovyBlock((ASTNode)astNode, Indent.getAbsoluteNoneIndent(), null, new FormattingContext(groovySettings, alignments, customSettings, false, false, GroovyBlockProducer.DEFAULT));
        if (Registry.is((String)"groovy.document.based.formatting")) {
            return new DocumentBasedFormattingModel((Block)block, settings, containingFile);
        }
        return new GroovyFormattingModel(containingFile, block, FormattingDocumentModelImpl.createOn((PsiFile)containingFile));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "formattingContext", "org/jetbrains/plugins/groovy/formatter/GroovyFormattingModelBuilder", "createModel"));
    }

    private static class GroovyFormattingModel
    extends PsiBasedFormattingModel {
        GroovyFormattingModel(PsiFile file, @NotNull Block rootBlock, FormattingDocumentModelImpl documentModel) {
            if (rootBlock == null) {
                GroovyFormattingModel.$$$reportNull$$$0(0);
            }
            super(file, rootBlock, documentModel);
        }

        protected String replaceWithPsiInLeaf(TextRange textRange, String whiteSpace, ASTNode leafElement) {
            if (!this.myCanModifyAllWhiteSpaces && PsiImplUtil.isWhiteSpaceOrNls(leafElement)) {
                return null;
            }
            IElementType elementTypeToUse = TokenType.WHITE_SPACE;
            ASTNode prevNode = TreeUtil.prevLeaf((ASTNode)leafElement);
            if (prevNode != null && PsiImplUtil.isWhiteSpaceOrNls(prevNode)) {
                elementTypeToUse = prevNode.getElementType();
            }
            FormatterUtil.replaceWhiteSpace((String)whiteSpace, (ASTNode)leafElement, (IElementType)elementTypeToUse, (TextRange)textRange);
            return whiteSpace;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootBlock", "org/jetbrains/plugins/groovy/formatter/GroovyFormattingModelBuilder$GroovyFormattingModel", "<init>"));
        }
    }
}

