/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.performancePlugin.commands;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.ui.playback.PlaybackContext;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.AsyncFileListener;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.jetbrains.performancePlugin.PerformanceTestSpan;
import com.jetbrains.performancePlugin.utils.AbstractCallbackBasedCommand;
import io.opentelemetry.api.trace.Span;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u000e2\u00020\u0001:\u0001\u000eB\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0014\u00a8\u0006\u000f"}, d2={"Lcom/jetbrains/performancePlugin/commands/MeasureVFSUpdateCommand;", "Lcom/jetbrains/performancePlugin/utils/AbstractCallbackBasedCommand;", "text", "", "line", "", "<init>", "(Ljava/lang/String;I)V", "execute", "", "callback", "Lcom/intellij/openapi/util/ActionCallback;", "context", "Lcom/intellij/openapi/ui/playback/PlaybackContext;", "Companion", "intellij.performanceTesting"})
@SourceDebugExtension(value={"SMAP\nMeasureVFSUpdateCommand.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MeasureVFSUpdateCommand.kt\ncom/jetbrains/performancePlugin/commands/MeasureVFSUpdateCommand\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,57:1\n1869#2,2:58\n*S KotlinDebug\n*F\n+ 1 MeasureVFSUpdateCommand.kt\ncom/jetbrains/performancePlugin/commands/MeasureVFSUpdateCommand\n*L\n45#1:58,2\n*E\n"})
public final class MeasureVFSUpdateCommand
extends AbstractCallbackBasedCommand {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    public static final String PREFIX = "%measureVFSUpdate";
    @NotNull
    public static final String SPAN_NAME = "vfsUpdate";

    public MeasureVFSUpdateCommand(@NotNull String text, int line) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        super(text, line);
    }

    @Override
    protected void execute(@NotNull ActionCallback callback2, @NotNull PlaybackContext context) {
        Intrinsics.checkNotNullParameter((Object)callback2, (String)"callback");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        String path = this.extractCommandArgument(PREFIX);
        Disposable disposable = Disposer.newDisposable();
        Intrinsics.checkNotNullExpressionValue((Object)disposable, (String)"newDisposable(...)");
        Disposable disposer = disposable;
        if (context.getProject().getBasePath() == null) {
            callback2.reject("Project path is empty");
            return;
        }
        String string = context.getProject().getBasePath();
        Intrinsics.checkNotNull((Object)string);
        Path path2 = Paths.get(string, new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"get(...)");
        Path projectDir = path2;
        Intrinsics.checkNotNull((Object)path);
        Path path3 = projectDir.resolve(path);
        Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"resolve(...)");
        Path path4 = path3;
        String string2 = UUID.randomUUID().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
        Path path5 = path4.resolve(string2);
        Intrinsics.checkNotNullExpressionValue((Object)path5, (String)"resolve(...)");
        File testFile = path5.toFile();
        Span span = PerformanceTestSpan.TRACER.spanBuilder(SPAN_NAME).startSpan();
        boolean isFileCreated = FileUtil.createIfNotExists((File)testFile);
        if (!isFileCreated) {
            callback2.reject("File " + testFile.getPath() + " wasn't created");
            return;
        }
        VirtualFileManager.getInstance().addAsyncFileListener(arg_0 -> MeasureVFSUpdateCommand.execute$lambda$1(testFile, span, callback2, arg_0), disposer);
        VirtualFileManager.getInstance().refreshWithoutFileWatcher(true);
    }

    private static final AsyncFileListener.ChangeApplier execute$lambda$1(File $testFile, Span $span, ActionCallback $callback, List events) {
        Intrinsics.checkNotNullParameter((Object)events, (String)"events");
        Iterable $this$forEach$iv = events;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            VFileEvent it = (VFileEvent)element$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)it.getPath(), (Object)$testFile.getPath())) continue;
            $span.end();
            FileUtil.delete((File)$testFile);
            $callback.setDone();
        }
        return null;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0013\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0007\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/jetbrains/performancePlugin/commands/MeasureVFSUpdateCommand$Companion;", "", "<init>", "()V", "PREFIX", "", "Lorg/jetbrains/annotations/NonNls;", "SPAN_NAME", "intellij.performanceTesting"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

