/*
 * Decompiled with CFR 0.152.
 */
package docking.widgets.tree.internal;

import docking.widgets.tree.support.GTreeSelectionEvent;
import docking.widgets.tree.support.GTreeSelectionListener;
import ghidra.util.exception.AssertException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.tree.DefaultTreeSelectionModel;
import javax.swing.tree.TreePath;

public class GTreeSelectionModel
extends DefaultTreeSelectionModel {
    private List<GTreeSelectionListener> listeners = new ArrayList<GTreeSelectionListener>();
    private GTreeSelectionEvent.EventOrigin currentEventOrigin = GTreeSelectionEvent.EventOrigin.USER_GENERATED;

    public void addGTreeSelectionListener(GTreeSelectionListener listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    public void removeGTreeSelectionListener(GTreeSelectionListener listener) {
        this.listeners.remove(listener);
    }

    @Override
    protected void fireValueChanged(TreeSelectionEvent e) {
        super.fireValueChanged(e);
        this.fireValueChanged(new GTreeSelectionEvent(e, this.currentEventOrigin));
    }

    @Override
    public void clearSelection() {
        this.clearSelection(GTreeSelectionEvent.EventOrigin.INTERNAL_GENERATED);
    }

    @Override
    public final void removeSelectionPaths(TreePath[] paths) {
        this.currentEventOrigin = GTreeSelectionEvent.EventOrigin.INTERNAL_GENERATED;
        super.removeSelectionPaths(paths);
        this.currentEventOrigin = GTreeSelectionEvent.EventOrigin.USER_GENERATED;
    }

    public final void userRemovedSelectionPath(TreePath path) {
        this.currentEventOrigin = GTreeSelectionEvent.EventOrigin.USER_GENERATED;
        super.removeSelectionPaths(new TreePath[]{path});
        this.currentEventOrigin = GTreeSelectionEvent.EventOrigin.USER_GENERATED;
    }

    void clearSelection(GTreeSelectionEvent.EventOrigin origin) {
        this.currentEventOrigin = origin;
        super.clearSelection();
        this.currentEventOrigin = GTreeSelectionEvent.EventOrigin.USER_GENERATED;
    }

    private void fireValueChanged(GTreeSelectionEvent event) {
        for (GTreeSelectionListener listener : this.listeners) {
            listener.valueChanged(event);
        }
    }

    public void setSelectionPaths(TreePath[] paths, GTreeSelectionEvent.EventOrigin origin) {
        if (!SwingUtilities.isEventDispatchThread()) {
            throw new AssertException("Model must be used from within the event dispatch thread!");
        }
        this.currentEventOrigin = origin;
        this.setSelectionPaths(paths);
        this.currentEventOrigin = GTreeSelectionEvent.EventOrigin.USER_GENERATED;
    }
}

