/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.viewer.field;

import docking.widgets.checkbox.GCheckBox;
import docking.widgets.combobox.GhidraComboBox;
import docking.widgets.label.GDLabel;
import docking.widgets.textfield.IntegerTextField;
import ghidra.app.util.viewer.field.AddressFieldOptionsWrappedOption;
import ghidra.framework.options.CustomOptionsEditor;
import ghidra.util.HTMLUtilities;
import ghidra.util.layout.PairLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.beans.PropertyEditorSupport;
import java.math.BigInteger;
import javax.swing.JPanel;

public class AddressFieldOptionsPropertyEditor
extends PropertyEditorSupport
implements CustomOptionsEditor {
    private static final String SHOW_BLOCK_NAME_LABEL = "Show Block Name";
    private static final String ADDRESS_DIGITS_LABEL = "Minimum Number of Address digits";
    private static final String PADDING_LABEL = "Fully Pad With Leading Zeros";
    private static final String JUSTIFICATION_LABEL = "Justification";
    private static final String[] NAMES = new String[]{"Show Block Name", "Minimum Number of Address digits", "Fully Pad With Leading Zeros", "Justification"};
    private static final String ADDRESS_PADDING_TOOLTIP = HTMLUtilities.toWrappedHTML((String)"Pads Addresses with leading zeros to the full size of the largest possible address.", (int)75);
    private static final String MIN_HEX_DIGITS_TOOLTIP = HTMLUtilities.toWrappedHTML((String)"Specifies the minimum number of hex digits to display the address (The minimum is actually the smaller of this number and the number of digits in largest possible address in that address space.)", (int)75);
    private static final String SHOW_BLOCKNAME_TOOLTIP = HTMLUtilities.toWrappedHTML((String)"Prepends the Memory Block name to address in the address field.", (int)75);
    private static final String RIGHT_JUSTIFY_TOOLTIP = HTMLUtilities.toWrappedHTML((String)"Specifies the justification for address text in the address field. The address text will clip on the opposite side of the justification.", (int)75);
    private static final String[] DESCRIPTIONS = new String[]{ADDRESS_PADDING_TOOLTIP, MIN_HEX_DIGITS_TOOLTIP, SHOW_BLOCKNAME_TOOLTIP, RIGHT_JUSTIFY_TOOLTIP};
    private AddressFieldOptionsWrappedOption addressFieldOptionsWrappedOption;
    private Component editorComponent = this.buildEditor();
    private GCheckBox padCheckBox;
    private IntegerTextField minDigitsField;
    private GCheckBox showBlocknameCheckbox;
    private GhidraComboBox<String> justificationCombobox;

    private Component buildEditor() {
        JPanel panel = new JPanel((LayoutManager)new PairLayout(6, 10));
        GDLabel label = new GDLabel(SHOW_BLOCK_NAME_LABEL, 4);
        label.setToolTipText(SHOW_BLOCKNAME_TOOLTIP);
        panel.add((Component)label);
        this.showBlocknameCheckbox = new GCheckBox();
        this.showBlocknameCheckbox.setToolTipText(SHOW_BLOCKNAME_TOOLTIP);
        panel.add((Component)this.showBlocknameCheckbox);
        label = new GDLabel(PADDING_LABEL, 4);
        label.setToolTipText(ADDRESS_PADDING_TOOLTIP);
        panel.add((Component)label);
        this.padCheckBox = new GCheckBox();
        panel.add((Component)this.padCheckBox);
        this.padCheckBox.setSelected(false);
        this.padCheckBox.setToolTipText(ADDRESS_PADDING_TOOLTIP);
        label = new GDLabel(ADDRESS_DIGITS_LABEL, 4);
        label.setToolTipText(MIN_HEX_DIGITS_TOOLTIP);
        panel.add((Component)label);
        this.minDigitsField = new IntegerTextField(2);
        this.minDigitsField.setAllowNegativeValues(false);
        this.minDigitsField.setDecimalMode();
        this.minDigitsField.setMaxValue(BigInteger.valueOf(32L));
        this.minDigitsField.getComponent().setToolTipText(MIN_HEX_DIGITS_TOOLTIP);
        panel.add(this.minDigitsField.getComponent());
        label = new GDLabel(JUSTIFICATION_LABEL, 4);
        label.setToolTipText(RIGHT_JUSTIFY_TOOLTIP);
        panel.add((Component)label);
        this.justificationCombobox = new GhidraComboBox((Object[])new String[]{"Left", "Right"});
        this.justificationCombobox.setToolTipText(RIGHT_JUSTIFY_TOOLTIP);
        panel.add((Component)this.justificationCombobox);
        this.showBlocknameCheckbox.addItemListener(evt -> this.firePropertyChange());
        this.justificationCombobox.addItemListener(evt -> this.firePropertyChange());
        this.padCheckBox.addItemListener(evt -> {
            boolean enabled = !this.padCheckBox.isSelected();
            this.minDigitsField.setEnabled(enabled);
            this.firePropertyChange();
        });
        this.minDigitsField.addChangeListener(evt -> this.firePropertyChange());
        return panel;
    }

    @Override
    public void setValue(Object value) {
        if (!(value instanceof AddressFieldOptionsWrappedOption)) {
            return;
        }
        this.addressFieldOptionsWrappedOption = (AddressFieldOptionsWrappedOption)value;
        this.setLocalValues(this.addressFieldOptionsWrappedOption);
        this.firePropertyChange();
    }

    private int getMinNumberOfDigits() {
        return this.minDigitsField.getIntValue();
    }

    private void setLocalValues(AddressFieldOptionsWrappedOption addressPaddingOption) {
        if (addressPaddingOption.showBlockName() != this.showBlocknameCheckbox.isSelected()) {
            this.showBlocknameCheckbox.setSelected(addressPaddingOption.showBlockName());
        }
        boolean rightJust = this.justificationCombobox.getSelectedItem().equals("Right");
        if (addressPaddingOption.rightJustify() != rightJust) {
            this.justificationCombobox.setSelectedIndex(addressPaddingOption.rightJustify() ? 1 : 0);
        }
        if (addressPaddingOption.padWithZeros() != this.padCheckBox.isSelected()) {
            this.padCheckBox.setSelected(addressPaddingOption.padWithZeros());
        }
        if (!Integer.toString(addressPaddingOption.getMinimumHexDigits()).equals(this.minDigitsField.getText())) {
            this.minDigitsField.setValue(addressPaddingOption.getMinimumHexDigits());
        }
        boolean enabled = !this.padCheckBox.isSelected();
        this.minDigitsField.setEnabled(enabled);
    }

    private AddressFieldOptionsWrappedOption cloneAddressPadValues() {
        AddressFieldOptionsWrappedOption newOption = new AddressFieldOptionsWrappedOption();
        newOption.setPadWithZeros(this.padCheckBox.isSelected());
        newOption.setMinimumHexDigits(this.getMinNumberOfDigits());
        newOption.setShowBlockName(this.showBlocknameCheckbox.isSelected());
        newOption.setRightJustify(this.justificationCombobox.getSelectedItem().equals("Right"));
        return newOption;
    }

    public String[] getOptionDescriptions() {
        return DESCRIPTIONS;
    }

    public String[] getOptionNames() {
        return NAMES;
    }

    @Override
    public Object getValue() {
        return this.cloneAddressPadValues();
    }

    @Override
    public Component getCustomEditor() {
        return this.editorComponent;
    }

    @Override
    public boolean supportsCustomEditor() {
        return true;
    }
}

