/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.dwarf.attribs;

import ghidra.app.util.bin.format.dwarf.DWARFCompilationUnit;
import ghidra.app.util.bin.format.dwarf.DWARFProgram;
import ghidra.app.util.bin.format.dwarf.attribs.DWARFAttributeClass;
import ghidra.app.util.bin.format.dwarf.attribs.DWARFAttributeDef;
import ghidra.app.util.bin.format.dwarf.attribs.DWARFNumericAttribute;
import java.io.IOException;

public class DWARFIndirectAttribute
extends DWARFNumericAttribute {
    public DWARFIndirectAttribute(long index, DWARFAttributeDef<?> def) {
        super(index, def);
    }

    public int getIndex() throws IOException {
        return this.getUnsignedIntExact();
    }

    @Override
    public String toString(DWARFCompilationUnit cu) {
        try {
            DWARFProgram prog = cu.getProgram();
            int index = this.getIndex();
            long offset = prog.getOffsetOfIndexedElement(this.getAttributeForm(), index, cu);
            if (this.getAttributeForm().isClass(DWARFAttributeClass.address)) {
                return "%s : %s, addr v%d 0x%x (idx %d)".formatted(new Object[]{this.getAttributeName(), this.getAttributeForm(), cu.getDWARFVersion(), offset, index});
            }
            if (this.getAttributeForm().isClass(DWARFAttributeClass.rnglist)) {
                return this.toElementLocationString("rnglist", "debug_rnglists", index, offset, cu.getDWARFVersion());
            }
            if (this.getAttributeForm().isClass(DWARFAttributeClass.loclist)) {
                return this.toElementLocationString("loclist", "debug_loclists", index, offset, cu.getDWARFVersion());
            }
            if (this.getAttributeForm().isClass(DWARFAttributeClass.string)) {
                return this.toElementLocationString("string", "debug_loclists", index, offset, cu.getDWARFVersion());
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return super.toString(cu);
    }

    @Override
    public String toString() {
        long index = this.getUnsignedValue();
        return "%s : %s, index/offset %d [0x%x]".formatted(new Object[]{this.getAttributeName(), this.getAttributeForm(), index, index});
    }
}

