/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.datamgr.actions.associate;

import docking.ActionContext;
import docking.action.DockingAction;
import docking.action.MenuData;
import docking.widgets.OptionDialog;
import docking.widgets.tree.GTree;
import docking.widgets.tree.GTreeNode;
import generic.theme.GIcon;
import ghidra.app.plugin.core.datamgr.DataTypeManagerPlugin;
import ghidra.app.plugin.core.datamgr.DataTypeSyncState;
import ghidra.app.plugin.core.datamgr.DataTypeSynchronizer;
import ghidra.app.plugin.core.datamgr.DataTypesActionContext;
import ghidra.app.plugin.core.datamgr.archive.DataTypeManagerHandler;
import ghidra.app.plugin.core.datamgr.tree.DataTypeNode;
import ghidra.app.plugin.core.datamgr.util.DataTypeUtils;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.data.SourceArchive;
import java.awt.Component;
import javax.swing.Icon;
import javax.swing.tree.TreePath;
import resources.MultiIcon;
import resources.icons.EmptyIcon;
import resources.icons.TranslateIcon;

public class UpdateSingleDataTypeAction
extends DockingAction {
    private static Icon UPDATE_ICON = new GIcon("icon.plugin.datatypes.associate.single.type");
    private final DataTypeManagerPlugin plugin;

    public UpdateSingleDataTypeAction(DataTypeManagerPlugin plugin) {
        super("Update From Archive", plugin.getName());
        this.plugin = plugin;
        this.setPopupMenuData(new MenuData(new String[]{"Update From Archive"}, "Sync"));
        this.setEnabled(true);
        MultiIcon multiIcon = new MultiIcon((Icon)new EmptyIcon(16, 16));
        multiIcon.addIcon((Icon)new TranslateIcon(UPDATE_ICON, 4, 5));
    }

    public boolean isEnabledForContext(ActionContext context) {
        if (!(context instanceof DataTypesActionContext)) {
            return false;
        }
        Object contextObject = context.getContextObject();
        GTree gTree = (GTree)contextObject;
        TreePath[] selectionPaths = gTree.getSelectionPaths();
        if (selectionPaths == null || selectionPaths.length != 1) {
            return false;
        }
        GTreeNode node = (GTreeNode)selectionPaths[0].getLastPathComponent();
        if (!(node instanceof DataTypeNode)) {
            return false;
        }
        DataTypeNode dataTypeNode = (DataTypeNode)node;
        DataType dataType = dataTypeNode.getDataType();
        DataTypeManagerHandler handler = this.plugin.getDataTypeManagerHandler();
        DataTypeSyncState syncStatus = DataTypeSynchronizer.getSyncStatus(handler, dataType);
        switch (syncStatus) {
            case UNKNOWN: {
                return false;
            }
            case CONFLICT: 
            case UPDATE: {
                return true;
            }
            case IN_SYNC: 
            case COMMIT: 
            case ORPHAN: {
                return false;
            }
        }
        return false;
    }

    public void actionPerformed(ActionContext context) {
        int result;
        GTree gTree = (GTree)context.getContextObject();
        TreePath[] selectionPaths = gTree.getSelectionPaths();
        if (selectionPaths == null || selectionPaths.length != 1) {
            return;
        }
        GTreeNode node = (GTreeNode)selectionPaths[0].getLastPathComponent();
        if (!(node instanceof DataTypeNode)) {
            return;
        }
        DataTypeNode dataTypeNode = (DataTypeNode)node;
        DataType dataType = dataTypeNode.getDataType();
        DataTypeManager dtm = dataType.getDataTypeManager();
        DataTypeManagerHandler handler = this.plugin.getDataTypeManagerHandler();
        SourceArchive sourceArchive = dataType.getSourceArchive();
        DataTypeSyncState syncStatus = DataTypeSynchronizer.getSyncStatus(handler, dataType);
        if (syncStatus == DataTypeSyncState.CONFLICT && (result = OptionDialog.showOptionDialog((Component)gTree, (String)"Lose Local Changes?", (String)"This data type has local changes that will be\noverwritten if you update this data type", (String)"Continue?", (int)2)) == 0) {
            return;
        }
        if (!dtm.isUpdatable()) {
            DataTypeUtils.showUnmodifiableArchiveErrorMessage((Component)gTree, "Update Failed", dtm);
            return;
        }
        this.plugin.update(dataType);
        DataTypeManager sourceDTM = handler.getDataTypeManager(sourceArchive);
        if (sourceDTM != null) {
            DataTypeSynchronizer synchronizer = new DataTypeSynchronizer(handler, dtm, sourceArchive);
            synchronizer.reSyncOutOfSyncInTimeOnlyDataTypes();
        }
    }
}

