/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.altibase;

import java.sql.ResultSet;
import java.sql.SQLException;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ext.altibase.AltibaseConstants;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCPreparedStatement;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSObjectLazy;
import org.jkiss.dbeaver.model.struct.cache.DBSObjectCache;
import org.jkiss.utils.CommonUtils;

public class AltibaseUtils {
    static final Log log = Log.getLog(AltibaseUtils.class);

    public static <PARENT extends DBSObject> Object resolveLazyReference(DBRProgressMonitor monitor, PARENT parent, DBSObjectCache<PARENT, ?> cache, DBSObjectLazy<?> referrer, Object propertyId) throws DBException {
        Object reference = referrer.getLazyReference(propertyId);
        if (reference instanceof String) {
            DBSObject object = monitor != null ? cache.getObject(monitor, parent, (String)reference) : cache.getCachedObject((String)reference);
            if (object != null) {
                return object;
            }
            log.warn((Object)("Object '" + String.valueOf(reference) + "' not found"));
            return reference;
        }
        return reference;
    }

    public static boolean getViewStatus(JDBCSession session, String tableType, String schemaName, String objName) throws DBCException {
        boolean isValid = false;
        String qry = null;
        qry = "MATERIALIZED VIEW".equals(tableType) ? "SELECT v.status FROM system_.sys_users_ u, system_.sys_materialized_views_ m, system_.sys_views_ v WHERE u.user_id = m.user_id AND u.user_id = v.user_id AND v.view_id = m.view_id AND u.user_name = ? AND m.mview_name = ?" : "SELECT v.status FROM system_.sys_users_ u, system_.sys_tables_ t, system_.sys_views_ v WHERE u.user_id = t.user_id AND u.user_id = v.user_id AND v.view_id = t.table_id AND u.user_name = ? AND t.table_name = ?";
        try (JDBCPreparedStatement dbStat = session.prepareStatement(qry);){
            dbStat.setString(1, schemaName);
            dbStat.setString(2, objName);
            dbStat.executeStatement();
            try (JDBCResultSet dbResult = dbStat.getResultSet();){
                if (dbResult != null && dbResult.next()) {
                    isValid = JDBCUtils.safeGetBoolean((ResultSet)dbResult, (int)1, (String)"0");
                }
            }
        }
        catch (SQLException e) {
            throw new DBCException((Throwable)e, (DBCExecutionContext)session.getExecutionContext());
        }
        return isValid;
    }

    public static String getDmbsMetaDataObjTypeName(String objTypeName) {
        if (CommonUtils.isEmpty((String)objTypeName)) {
            return "UNKNOWN_OBJECT_TYPE";
        }
        return objTypeName.replaceAll(" ", "_");
    }

    private static int getEffectiveSqlLineNumber(String[] script) {
        int i = 0;
        for (String line : script) {
            if (line != null && line.trim().length() > 0 && !line.stripLeading().startsWith("--")) {
                return i;
            }
            ++i;
        }
        return i;
    }

    public static String getEffectiveSql(String script) {
        StringBuilder ddl = new StringBuilder();
        String[] lines = script.split("\\R");
        int i = 0;
        int length = lines.length;
        for (i = AltibaseUtils.getEffectiveSqlLineNumber(lines); i < length; ++i) {
            ddl.append(lines[i]).append(AltibaseConstants.NEW_LINE);
        }
        int last = ddl.length() - AltibaseConstants.NEW_LINE.length();
        return ddl.substring(0, last);
    }
}

