/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jsqlparser.util.cnfexpression;

import java.util.ArrayList;
import java.util.List;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.NotExpression;
import net.sf.jsqlparser.expression.operators.conditional.AndExpression;
import net.sf.jsqlparser.expression.operators.conditional.OrExpression;
import net.sf.jsqlparser.expression.operators.relational.ParenthesedExpressionList;
import net.sf.jsqlparser.util.cnfexpression.MultiAndExpression;
import net.sf.jsqlparser.util.cnfexpression.MultiOrExpression;
import net.sf.jsqlparser.util.cnfexpression.MultipleExpression;

class CloneHelper {
    CloneHelper() {
    }

    public static Expression modify(Expression express) {
        ParenthesedExpressionList parenthesis;
        if (express instanceof NotExpression) {
            return new NotExpression(CloneHelper.modify(((NotExpression)express).getExpression()));
        }
        if (express instanceof ParenthesedExpressionList && (parenthesis = (ParenthesedExpressionList)express).size() == 1) {
            return CloneHelper.modify((Expression)parenthesis.get(0));
        }
        if (express instanceof AndExpression) {
            AndExpression and = (AndExpression)express;
            ArrayList<Expression> list = new ArrayList<Expression>();
            list.add(CloneHelper.modify(and.getLeftExpression()));
            list.add(CloneHelper.modify(and.getRightExpression()));
            MultiAndExpression result = new MultiAndExpression(list);
            return result;
        }
        if (express instanceof OrExpression) {
            OrExpression or = (OrExpression)express;
            ArrayList<Expression> list = new ArrayList<Expression>();
            list.add(CloneHelper.modify(or.getLeftExpression()));
            list.add(CloneHelper.modify(or.getRightExpression()));
            MultiOrExpression result = new MultiOrExpression(list);
            return result;
        }
        return express;
    }

    public static Expression shallowCopy(Expression express) {
        if (express instanceof MultipleExpression) {
            MultipleExpression multi = (MultipleExpression)express;
            ArrayList<Expression> list = new ArrayList<Expression>();
            for (int i = 0; i < multi.size(); ++i) {
                list.add(CloneHelper.shallowCopy(multi.getChild(i)));
            }
            if (express instanceof MultiAndExpression) {
                return new MultiAndExpression(list);
            }
            return new MultiOrExpression(list);
        }
        return express;
    }

    public static Expression changeBack(Boolean isMultiOr, Expression exp) {
        if (!(exp instanceof MultipleExpression)) {
            return exp;
        }
        List<Expression> result = ((MultipleExpression)exp).getList();
        while (result.size() > 1) {
            ArrayList<Expression> compressed = new ArrayList<Expression>();
            for (int i = 0; i < result.size(); i += 2) {
                Expression right;
                Expression left = result.get(i);
                Expression expression = right = i + 1 < result.size() ? result.get(i + 1) : null;
                if (isMultiOr.booleanValue()) {
                    compressed.add(right != null ? new OrExpression(left, right) : left);
                    continue;
                }
                compressed.add(right != null ? new AndExpression(left, right) : left);
            }
            result = compressed;
        }
        if (isMultiOr.booleanValue()) {
            return new ParenthesedExpressionList(new Expression[]{result.get(0)});
        }
        return result.get(0);
    }
}

