/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.dialogs;

import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.dialogs.BaseDialog;
import org.jkiss.dbeaver.ui.internal.UIMessages;
import org.jkiss.utils.CommonUtils;

public class EditUserDialog
extends BaseDialog {
    private String name;
    private String password;
    private String verifyText;

    public EditUserDialog(@NotNull Shell parentShell, @NotNull String title) {
        super(parentShell, title, null);
    }

    @Override
    @NotNull
    protected Composite createDialogArea(@NotNull Composite parent) {
        Composite composite = super.createDialogArea(parent);
        Composite groupGeneral = UIUtils.createTitledComposite(composite, UIMessages.dialogs_name_and_password_dialog_group_settings, 2, 768);
        Text nameText = UIUtils.createLabelText(groupGeneral, UIMessages.dialogs_name_and_password_dialog_label_name, "");
        nameText.addModifyListener(e -> {
            this.name = nameText.getText().trim();
            this.updateButtons();
        });
        Text passwordText = UIUtils.createLabelText(groupGeneral, UIMessages.dialogs_name_and_password_dialog_label_password, "", 0x400800);
        passwordText.addModifyListener(e -> {
            this.password = passwordText.getText();
            this.updateButtons();
        });
        Text verifyPasswordText = UIUtils.createLabelText(groupGeneral, UIMessages.dialogs_name_and_password_dialog_label_verify_password, "", 0x400800);
        verifyPasswordText.addModifyListener(e -> {
            this.verifyText = verifyPasswordText.getText();
            this.updateButtons();
        });
        return composite;
    }

    public String getName() {
        return this.name;
    }

    public String getPassword() {
        return this.password;
    }

    @Override
    protected void createButtonsForButtonBar(@NotNull Composite parent) {
        super.createButtonsForButtonBar(parent);
        this.enableButton(0, false);
    }

    private void updateButtons() {
        this.enableButton(0, CommonUtils.isNotEmpty((String)this.name) && CommonUtils.isNotEmpty((String)this.password) && CommonUtils.equalObjects((Object)this.password, (Object)this.verifyText));
    }
}

