/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.ai.engine;

import java.util.List;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.ai.AIMessageType;
import org.jkiss.dbeaver.model.ai.AIUsage;
import org.jkiss.dbeaver.model.ai.engine.AIFunctionCall;

public class AIEngineResponse {
    @NotNull
    private final AIMessageType type;
    @Nullable
    private final List<String> variants;
    @Nullable
    private final AIFunctionCall functionCall;
    @Nullable
    private final AIUsage usage;
    private int processingTime;

    public AIEngineResponse(@NotNull AIMessageType type, @NotNull List<String> variants, @Nullable AIUsage usage) {
        this.type = type;
        this.variants = variants;
        this.usage = usage;
        this.functionCall = null;
    }

    public AIEngineResponse(@NotNull AIFunctionCall functionCall, @Nullable AIUsage usage) {
        this.usage = usage;
        this.type = AIMessageType.FUNCTION;
        this.variants = null;
        this.functionCall = functionCall;
    }

    @NotNull
    public AIMessageType getType() {
        return this.type;
    }

    @Nullable
    public List<String> getVariants() {
        return this.variants;
    }

    @Nullable
    public AIFunctionCall getFunctionCall() {
        return this.functionCall;
    }

    @Nullable
    public AIUsage getUsage() {
        return this.usage;
    }

    public String toString() {
        return "AI response (" + String.valueOf((Object)this.type) + ") " + String.valueOf(this.variants != null ? this.variants : this.functionCall);
    }
}

