/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.sql.translate;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import net.sf.jsqlparser.statement.ReferentialAction;
import net.sf.jsqlparser.statement.Statement;
import net.sf.jsqlparser.statement.alter.Alter;
import net.sf.jsqlparser.statement.alter.AlterExpression;
import net.sf.jsqlparser.statement.alter.AlterOperation;
import net.sf.jsqlparser.statement.create.table.ColumnDefinition;
import net.sf.jsqlparser.statement.create.table.CreateTable;
import net.sf.jsqlparser.statement.create.table.ForeignKeyIndex;
import net.sf.jsqlparser.statement.create.table.Index;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.impl.preferences.SimplePreferenceStore;
import org.jkiss.dbeaver.model.preferences.DBPPreferenceStore;
import org.jkiss.dbeaver.model.sql.SQLDialect;
import org.jkiss.dbeaver.model.sql.SQLDialectDDLExtension;
import org.jkiss.dbeaver.model.sql.SQLQuery;
import org.jkiss.dbeaver.model.sql.SQLScriptElement;
import org.jkiss.dbeaver.model.sql.format.SQLFormatUtils;
import org.jkiss.dbeaver.model.sql.parser.SQLScriptParser;
import org.jkiss.dbeaver.model.sql.translate.SQLTranslateContext;
import org.jkiss.dbeaver.model.sql.translate.SQLTranslator;
import org.jkiss.utils.CommonUtils;

public class SQLQueryTranslator
implements SQLTranslator {
    @NotNull
    private SQLTranslateContext sqlTranslateContext;

    public SQLQueryTranslator(@NotNull SQLTranslateContext sqlTranslateContext) {
        this.sqlTranslateContext = sqlTranslateContext;
    }

    @NotNull
    public static String translateScript(@NotNull SQLDialect sourceDialect, @NotNull SQLDialect targetDialect, @NotNull DBPPreferenceStore preferenceStore, @NotNull String script) throws DBException {
        SQLTranslateContext context = new SQLTranslateContext(sourceDialect, targetDialect, preferenceStore);
        List<SQLScriptElement> sqlScriptElements = SQLScriptParser.parseScript(null, sourceDialect, preferenceStore, script);
        ArrayList<? extends SQLScriptElement> result = new ArrayList<SQLScriptElement>();
        SQLQueryTranslator defaultSQLQueryTranslator = new SQLQueryTranslator(context);
        for (SQLScriptElement element : sqlScriptElements) {
            result.addAll(defaultSQLQueryTranslator.translate(element));
        }
        String scriptDelimiter = targetDialect.getScriptDelimiters()[0];
        StringBuilder sql = new StringBuilder();
        for (SQLScriptElement sQLScriptElement : result) {
            sql.append(sQLScriptElement.getText());
            sql.append(scriptDelimiter).append("\n");
        }
        return sql.toString();
    }

    @Override
    @NotNull
    public List<? extends SQLScriptElement> translate(@NotNull SQLScriptElement element) throws DBException {
        if (element instanceof SQLQuery) {
            return this.translateQuery((SQLQuery)element);
        }
        return Collections.singletonList(element);
    }

    @NotNull
    private List<? extends SQLScriptElement> translateQuery(@NotNull SQLQuery query) {
        Statement statement = query.getStatement();
        if (statement != null) {
            return this.translateStatement(query, statement);
        }
        return Collections.singletonList(query);
    }

    @NotNull
    protected List<? extends SQLScriptElement> translateStatement(@NotNull SQLQuery query, @NotNull Statement statement) {
        boolean defChanged;
        ArrayList<SQLQuery> postExtraQueries;
        ArrayList<SQLQuery> extraQueries;
        block26: {
            Alter alter;
            SQLDialectDDLExtension extendedDialect;
            SQLDialect targetDialect;
            block24: {
                extraQueries = null;
                postExtraQueries = new ArrayList<SQLQuery>();
                defChanged = false;
                targetDialect = this.sqlTranslateContext.getTargetDialect();
                extendedDialect = null;
                if (targetDialect instanceof SQLDialectDDLExtension) {
                    extendedDialect = (SQLDialectDDLExtension)targetDialect;
                }
                if (!(statement instanceof CreateTable)) break block24;
                CreateTable createTable = (CreateTable)statement;
                if (extendedDialect != null && extendedDialect.supportsCreateIfExists()) {
                    createTable.setIfNotExists(false);
                    defChanged = true;
                }
                List columnDefinitions = createTable.getColumnDefinitions();
                for (ColumnDefinition cd : columnDefinitions) {
                    defChanged |= this.translateColumnDataType(cd, extendedDialect, targetDialect);
                    if (CommonUtils.isEmpty((Collection)cd.getColumnSpecs())) continue;
                    for (String columnSpec : new ArrayList(cd.getColumnSpecs())) {
                        switch (columnSpec.toUpperCase(Locale.ENGLISH)) {
                            case "AUTO_INCREMENT": 
                            case "IDENTITY": {
                                if (!targetDialect.supportsColumnAutoIncrement()) {
                                    String schemaName = createTable.getTable().getSchemaName();
                                    String sequenceWithoutSchemaName = CommonUtils.escapeIdentifier((String)createTable.getTable().getName()) + "_" + CommonUtils.escapeIdentifier((String)cd.getColumnName());
                                    String sequenceName = schemaName == null ? sequenceWithoutSchemaName : schemaName + "." + sequenceWithoutSchemaName;
                                    cd.getColumnSpecs().remove(columnSpec);
                                    cd.getColumnSpecs().add("DEFAULT");
                                    cd.getColumnSpecs().add("NEXTVAL('" + sequenceName + "')");
                                    defChanged = true;
                                    String createSeqQuery = "CREATE SEQUENCE " + sequenceName;
                                    if (extraQueries == null) {
                                        extraQueries = new ArrayList();
                                    }
                                    extraQueries.add(new SQLQuery(null, createSeqQuery));
                                    String linkSeqWithTable = "ALTER SEQUENCE " + sequenceName + " OWNED BY " + createTable.getTable().getFullyQualifiedName() + "." + cd.getColumnName();
                                    postExtraQueries.add(new SQLQuery(null, linkSeqWithTable));
                                    break;
                                }
                                if (extendedDialect == null) break;
                                int indexOf = cd.getColumnSpecs().indexOf(columnSpec);
                                defChanged = true;
                                cd.getColumnSpecs().set(indexOf, extendedDialect.getAutoIncrementKeyword());
                                break;
                            }
                        }
                    }
                }
                if (extendedDialect != null && !extendedDialect.supportsNoActionIndex() && !CommonUtils.isEmpty((Collection)createTable.getIndexes())) {
                    for (Index index : createTable.getIndexes()) {
                        ForeignKeyIndex fkIndex;
                        ReferentialAction ra;
                        if (!(index instanceof ForeignKeyIndex) || (ra = (fkIndex = (ForeignKeyIndex)index).getReferentialAction(ReferentialAction.Type.DELETE)) == null || !ReferentialAction.Action.NO_ACTION.equals((Object)ra.getAction())) continue;
                        fkIndex.removeReferentialAction(ReferentialAction.Type.DELETE);
                        defChanged = true;
                    }
                }
                break block26;
            }
            if (statement instanceof Alter && (alter = (Alter)statement).getAlterExpressions() != null) {
                for (AlterExpression expr : alter.getAlterExpressions()) {
                    List columnDataTypeList = expr.getColDataTypeList();
                    if (columnDataTypeList == null) continue;
                    if (extendedDialect != null && expr.getOperation().equals((Object)AlterOperation.ALTER)) {
                        expr.setOperation(AlterOperation.valueOf((String)extendedDialect.getAlterColumnOperation().toUpperCase()));
                        expr.hasColumn(extendedDialect.supportsAlterHasColumn());
                        defChanged = true;
                    }
                    for (ColumnDefinition columnDataType : columnDataTypeList) {
                        defChanged |= this.translateColumnDataType(columnDataType, extendedDialect, targetDialect);
                    }
                }
            }
        }
        if (defChanged) {
            String newQueryText = SQLFormatUtils.formatSQL(null, this.sqlTranslateContext.getSyntaxManager(), statement.toString());
            query.setText(newQueryText);
            if (extraQueries == null) {
                extraQueries = new ArrayList<SQLQuery>();
            }
            extraQueries.add(query);
            extraQueries.addAll(postExtraQueries);
        }
        if (extraQueries == null) {
            return Collections.singletonList(query);
        }
        return extraQueries;
    }

    private boolean translateColumnDataType(ColumnDefinition cd, SQLDialectDDLExtension extendedDialect, SQLDialect targetDialect) {
        String colDataType;
        String newDataType = null;
        switch (colDataType = cd.getColDataType() != null ? cd.getColDataType().getDataType().toUpperCase(Locale.ENGLISH) : "") {
            case "CLOB": {
                newDataType = extendedDialect != null ? extendedDialect.getClobDataType() : "varchar";
                break;
            }
            case "BLOB": {
                newDataType = extendedDialect != null ? extendedDialect.getBlobDataType() : "blob";
                break;
            }
            case "TEXT": {
                String dialectName = targetDialect.getDialectName().toLowerCase();
                if (extendedDialect == null || !dialectName.equals("oracle") && !dialectName.equals("sqlserver")) break;
                newDataType = extendedDialect.getClobDataType();
                break;
            }
            case "TIMESTAMP": {
                if (extendedDialect == null) break;
                newDataType = extendedDialect.getTimestampDataType();
                break;
            }
            case "BIGINT": {
                if (extendedDialect == null) break;
                newDataType = extendedDialect.getBigIntegerType();
                break;
            }
            case "UUID": {
                if (extendedDialect == null) break;
                newDataType = extendedDialect.getUuidDataType();
                break;
            }
            case "BOOLEAN": {
                if (extendedDialect == null) break;
                newDataType = extendedDialect.getBooleanDataType();
                break;
            }
            case "SET": {
                if (extendedDialect == null || extendedDialect.supportsAlterColumnSet()) break;
                newDataType = "";
                break;
            }
        }
        if (newDataType != null) {
            cd.getColDataType().setDataType(newDataType);
            return true;
        }
        return false;
    }

    @NotNull
    public SQLTranslateContext getSqlTranslateContext() {
        return this.sqlTranslateContext;
    }

    public void setSqlTranslateContext(@NotNull SQLTranslateContext sqlTranslateContext) {
        this.sqlTranslateContext = sqlTranslateContext;
    }

    @NotNull
    public static DBPPreferenceStore getDefaultPreferenceStore() {
        SimplePreferenceStore prefStore = new SimplePreferenceStore(){

            public void save() throws IOException {
            }
        };
        prefStore.setValue("sql.format.formatter", "default");
        return prefStore;
    }
}

