﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/lookoutequipment/LookoutEquipment_EXPORTS.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Json {
class JsonValue;
}  // namespace Json
}  // namespace Utils
namespace LookoutEquipment {
namespace Model {
class CreateLabelGroupResult {
 public:
  AWS_LOOKOUTEQUIPMENT_API CreateLabelGroupResult() = default;
  AWS_LOOKOUTEQUIPMENT_API CreateLabelGroupResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
  AWS_LOOKOUTEQUIPMENT_API CreateLabelGroupResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);

  ///@{
  /**
   * <p> The name of the label group that you have created. Data in this field will
   * be retained for service usage. Follow best practices for the security of your
   * data. </p>
   */
  inline const Aws::String& GetLabelGroupName() const { return m_labelGroupName; }
  template <typename LabelGroupNameT = Aws::String>
  void SetLabelGroupName(LabelGroupNameT&& value) {
    m_labelGroupNameHasBeenSet = true;
    m_labelGroupName = std::forward<LabelGroupNameT>(value);
  }
  template <typename LabelGroupNameT = Aws::String>
  CreateLabelGroupResult& WithLabelGroupName(LabelGroupNameT&& value) {
    SetLabelGroupName(std::forward<LabelGroupNameT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p> The Amazon Resource Name (ARN) of the label group that you have created.
   * </p>
   */
  inline const Aws::String& GetLabelGroupArn() const { return m_labelGroupArn; }
  template <typename LabelGroupArnT = Aws::String>
  void SetLabelGroupArn(LabelGroupArnT&& value) {
    m_labelGroupArnHasBeenSet = true;
    m_labelGroupArn = std::forward<LabelGroupArnT>(value);
  }
  template <typename LabelGroupArnT = Aws::String>
  CreateLabelGroupResult& WithLabelGroupArn(LabelGroupArnT&& value) {
    SetLabelGroupArn(std::forward<LabelGroupArnT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::String& GetRequestId() const { return m_requestId; }
  template <typename RequestIdT = Aws::String>
  void SetRequestId(RequestIdT&& value) {
    m_requestIdHasBeenSet = true;
    m_requestId = std::forward<RequestIdT>(value);
  }
  template <typename RequestIdT = Aws::String>
  CreateLabelGroupResult& WithRequestId(RequestIdT&& value) {
    SetRequestId(std::forward<RequestIdT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_labelGroupName;

  Aws::String m_labelGroupArn;

  Aws::String m_requestId;
  bool m_labelGroupNameHasBeenSet = false;
  bool m_labelGroupArnHasBeenSet = false;
  bool m_requestIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace LookoutEquipment
}  // namespace Aws
