/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.visible.filters;

import com.intellij.util.text.DateFormatUtil;
import com.intellij.vcs.log.VcsCommitMetadata;
import com.intellij.vcs.log.VcsLogBundle;
import com.intellij.vcs.log.VcsLogDateFilter;
import com.intellij.vcs.log.VcsLogDetailsFilter;
import java.util.Date;
import java.util.Objects;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class VcsLogDateFilterImpl
implements VcsLogDateFilter,
VcsLogDetailsFilter {
    @Nullable
    private final Date myAfter;
    @Nullable
    private final Date myBefore;

    VcsLogDateFilterImpl(@Nullable Date after, @Nullable Date before) {
        this.myAfter = after;
        this.myBefore = before;
    }

    public boolean matches(@NotNull VcsCommitMetadata details) {
        if (details == null) {
            VcsLogDateFilterImpl.$$$reportNull$$$0(0);
        }
        Date date = new Date(details.getCommitTime());
        boolean matches = true;
        if (this.myAfter != null) {
            matches &= date.after(this.myAfter);
        }
        if (this.myBefore != null) {
            matches &= date.before(this.myBefore);
        }
        return matches;
    }

    @Nullable
    public Date getAfter() {
        return this.myAfter;
    }

    @Nullable
    public Date getBefore() {
        return this.myBefore;
    }

    @NotNull
    public String getDisplayText() {
        if (this.getBefore() != null && this.getAfter() != null) {
            String after = DateFormatUtil.formatDate((Date)this.getAfter());
            String before = DateFormatUtil.formatDate((Date)this.getBefore());
            String string = VcsLogBundle.message("vcs.log.filter.date.display.name.between", after, before);
            if (string == null) {
                VcsLogDateFilterImpl.$$$reportNull$$$0(1);
            }
            return string;
        }
        if (this.getAfter() != null) {
            String string = VcsLogBundle.message("vcs.log.filter.date.display.name.after", DateFormatUtil.formatDate((Date)this.getAfter()));
            if (string == null) {
                VcsLogDateFilterImpl.$$$reportNull$$$0(2);
            }
            return string;
        }
        if (this.getBefore() != null) {
            String string = VcsLogBundle.message("vcs.log.filter.date.display.name.before", DateFormatUtil.formatDate((Date)this.getBefore()));
            if (string == null) {
                VcsLogDateFilterImpl.$$$reportNull$$$0(3);
            }
            return string;
        }
        return "";
    }

    @Nls
    @NotNull
    static String getDisplayTextWithPrefix(@NotNull VcsLogDateFilter filter) {
        if (filter == null) {
            VcsLogDateFilterImpl.$$$reportNull$$$0(4);
        }
        if (filter.getBefore() != null && filter.getAfter() != null) {
            String after = DateFormatUtil.formatDate((Date)filter.getAfter());
            String before = DateFormatUtil.formatDate((Date)filter.getBefore());
            String string = VcsLogBundle.message("vcs.log.filter.date.presentation.with.prefix.made.between", after, before);
            if (string == null) {
                VcsLogDateFilterImpl.$$$reportNull$$$0(5);
            }
            return string;
        }
        if (filter.getAfter() != null) {
            String string = VcsLogBundle.message("vcs.log.filter.date.presentation.with.prefix.made.after", DateFormatUtil.formatDate((Date)filter.getAfter()));
            if (string == null) {
                VcsLogDateFilterImpl.$$$reportNull$$$0(6);
            }
            return string;
        }
        if (filter.getBefore() != null) {
            String string = VcsLogBundle.message("vcs.log.filter.date.presentation.with.prefix.made.before", DateFormatUtil.formatDate((Date)filter.getBefore()));
            if (string == null) {
                VcsLogDateFilterImpl.$$$reportNull$$$0(7);
            }
            return string;
        }
        return "";
    }

    public String toString() {
        return (String)(this.myAfter != null ? "after " + String.valueOf(this.myAfter) + (this.myBefore != null ? " " : "") : "") + (String)(this.myBefore != null ? "before " + String.valueOf(this.myBefore) : "");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VcsLogDateFilterImpl filter = (VcsLogDateFilterImpl)o;
        return Objects.equals(this.getAfter(), filter.getAfter()) && Objects.equals(this.getBefore(), filter.getBefore());
    }

    public int hashCode() {
        return Objects.hash(this.getAfter(), this.getBefore());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 3, 5, 6, 7 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "details";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/vcs/log/visible/filters/VcsLogDateFilterImpl";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/vcs/log/visible/filters/VcsLogDateFilterImpl";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayText";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayTextWithPrefix";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "matches";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getDisplayTextWithPrefix";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 3, 5, 6, 7 -> new IllegalStateException(string);
        };
    }
}

