/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.inspections;

import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.modcommand.ModCommandAction;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.jetbrains.python.PyPsiBundle;
import com.jetbrains.python.inspections.PyInconsistentReturnsInspectionKt;
import com.jetbrains.python.inspections.PyInspection;
import com.jetbrains.python.inspections.PyInspectionVisitor;
import com.jetbrains.python.inspections.quickfix.PyMakeReturnExplicitFix;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyReturnStatement;
import com.jetbrains.python.psi.PyStatement;
import com.jetbrains.python.psi.types.TypeEvalContext;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\f"}, d2={"Lcom/jetbrains/python/inspections/PyInconsistentReturnsInspection;", "Lcom/jetbrains/python/inspections/PyInspection;", "<init>", "()V", "buildVisitor", "Lcom/intellij/psi/PsiElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "session", "Lcom/intellij/codeInspection/LocalInspectionToolSession;", "intellij.python.psi.impl"})
public final class PyInconsistentReturnsInspection
extends PyInspection {
    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly, @NotNull LocalInspectionToolSession session) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        TypeEvalContext typeEvalContext = PyInspectionVisitor.getContext(session);
        return (PsiElementVisitor)new PyInspectionVisitor(holder, typeEvalContext){

            public void visitPyFunction(PyFunction node) {
                boolean hasExplicitReturns;
                List returnPoints;
                block8: {
                    Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                    List list = node.getReturnPoints(this.myTypeEvalContext);
                    Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getReturnPoints(...)");
                    returnPoints = list;
                    Iterable $this$any$iv = returnPoints;
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        v1 = false;
                    } else {
                        for (T element$iv : $this$any$iv) {
                            PyStatement it = (PyStatement)element$iv;
                            boolean bl = false;
                            if (!(it instanceof PyReturnStatement && ((PyReturnStatement)it).getExpression() != null)) continue;
                            v1 = true;
                            break block8;
                        }
                        v1 = hasExplicitReturns = false;
                    }
                }
                if (!hasExplicitReturns) {
                    return;
                }
                for (PyStatement statement : returnPoints) {
                    String string;
                    if (statement instanceof PyReturnStatement && ((PyReturnStatement)statement).getExpression() == null) {
                        string = PyPsiBundle.message("INSP.inconsistent.returns.return.without.value", new Object[0]);
                    } else {
                        if (statement instanceof PyReturnStatement) continue;
                        Intrinsics.checkNotNull((Object)statement);
                        TypeEvalContext typeEvalContext = this.myTypeEvalContext;
                        Intrinsics.checkNotNullExpressionValue((Object)typeEvalContext, (String)"myTypeEvalContext");
                        if (PyInconsistentReturnsInspectionKt.access$isTooComplexCase(statement, typeEvalContext)) continue;
                        string = PyPsiBundle.message("INSP.inconsistent.returns.missing.return.stmt.on.some.paths", new Object[0]);
                    }
                    String string2 = string;
                    Intrinsics.checkNotNull((Object)string2);
                    String message = string2;
                    ProblemsHolder problemsHolder = this.getHolder();
                    Intrinsics.checkNotNull((Object)problemsHolder);
                    ProblemsHolder.ProblemBuilder problemBuilder = problemsHolder.problem((PsiElement)statement, message);
                    TextRange textRange = PyInconsistentReturnsInspectionKt.access$firstLineRange((PsiElement)statement);
                    if (textRange == null) {
                        textRange = statement.getTextRange();
                    }
                    problemBuilder.range(textRange).fix((ModCommandAction)new PyMakeReturnExplicitFix(statement)).register();
                }
            }
        };
    }
}

