/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.coverage.actions;

import com.intellij.codeInsight.hint.HintManagerImpl;
import com.intellij.coverage.CoverageBundle;
import com.intellij.coverage.CoverageDataManager;
import com.intellij.coverage.CoverageSuitesBundle;
import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ui.configuration.actions.IconWithTextAction;
import com.intellij.ui.components.labels.LinkLabel;
import java.awt.Component;
import java.util.Collection;
import java.util.Objects;
import javax.swing.JComponent;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public class HideCoverageInfoAction
extends IconWithTextAction {
    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            HideCoverageInfoAction.$$$reportNull$$$0(0);
        }
        Project project = Objects.requireNonNull((Project)e.getData(CommonDataKeys.PROJECT));
        HideCoverageInfoAction.doAction(project);
    }

    private static void doAction(Project project) {
        CoverageDataManager manager = CoverageDataManager.getInstance(project);
        for (CoverageSuitesBundle bundle : manager.activeSuites()) {
            manager.closeSuitesBundle(bundle);
        }
    }

    @NotNull
    public JComponent createCustomComponent(@NotNull Presentation presentation, @NotNull String place) {
        if (presentation == null) {
            HideCoverageInfoAction.$$$reportNull$$$0(1);
        }
        if (place == null) {
            HideCoverageInfoAction.$$$reportNull$$$0(2);
        }
        return new LinkLabel<Object>(CoverageBundle.message("coverage.hide.coverage.link.name", new Object[0]), null){

            public void doClick() {
                DataContext dataContext = DataManager.getInstance().getDataContext((Component)((Object)this));
                Project project = Objects.requireNonNull((Project)CommonDataKeys.PROJECT.getData(dataContext));
                HideCoverageInfoAction.doAction(project);
                HintManagerImpl.getInstanceImpl().hideAllHints();
            }
        };
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.EDT;
        if (actionUpdateThread == null) {
            HideCoverageInfoAction.$$$reportNull$$$0(3);
        }
        return actionUpdateThread;
    }

    public void update(@NotNull AnActionEvent e) {
        Project project;
        if (e == null) {
            HideCoverageInfoAction.$$$reportNull$$$0(4);
        }
        if ((project = e.getProject()) == null) {
            return;
        }
        Collection<CoverageSuitesBundle> activeSuites = CoverageDataManager.getInstance(project).activeSuites();
        e.getPresentation().setEnabledAndVisible(!activeSuites.isEmpty());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "presentation";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/coverage/actions/HideCoverageInfoAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/coverage/actions/HideCoverageInfoAction";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createCustomComponent";
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3 -> new IllegalStateException(string);
        };
    }
}

