/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.substance.api.renderers;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JList;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.ListUI;
import javax.swing.plaf.UIResource;
import org.jvnet.lafwidget.animation.FadeKind;
import org.jvnet.substance.SubstanceListUI;
import org.jvnet.substance.SubstanceLookAndFeel;
import org.jvnet.substance.api.ComponentState;
import org.jvnet.substance.api.SubstanceApi;
import org.jvnet.substance.api.SubstanceColorScheme;
import org.jvnet.substance.utils.SubstanceColorSchemeUtilities;
import org.jvnet.substance.utils.SubstanceColorUtilities;
import org.jvnet.substance.utils.SubstanceSizeUtils;
import org.jvnet.substance.utils.SubstanceStripingUtils;

@SubstanceApi
public class SubstanceDefaultListCellRenderer
extends DefaultListCellRenderer {
    public SubstanceDefaultListCellRenderer() {
        this.putClientProperty("substancelaf.colorizationFactor", 1.0);
    }

    @Override
    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        this.setComponentOrientation(list.getComponentOrientation());
        ListUI listUI = list.getUI();
        if (listUI instanceof SubstanceListUI) {
            SubstanceColorScheme scheme;
            SubstanceListUI ui = (SubstanceListUI)listUI;
            ComponentState state = ui.getCellState(index, this);
            ComponentState prevState = ui.getPrevCellState(index);
            SubstanceColorScheme substanceColorScheme = scheme = state == ComponentState.DEFAULT ? ui.getDefaultColorScheme() : SubstanceColorSchemeUtilities.getColorScheme(list, state);
            if (scheme == null) {
                scheme = SubstanceColorSchemeUtilities.getColorScheme(list, state);
            }
            Color color = SubstanceColorUtilities.getInterpolatedForegroundColor(list, Integer.valueOf(index), scheme, state, prevState, FadeKind.SELECTION, FadeKind.ROLLOVER);
            super.setForeground(new ColorUIResource(color));
        } else if (isSelected) {
            this.setForeground(list.getSelectionForeground());
        } else {
            this.setForeground(list.getForeground());
        }
        if (!isSelected && SubstanceLookAndFeel.isCurrentLookAndFeel()) {
            SubstanceStripingUtils.applyStripedBackground(list, index, this);
        }
        if (value instanceof Icon) {
            this.setIcon((Icon)value);
            this.setText("");
        } else {
            this.setIcon(null);
            this.setText(value == null ? "" : value.toString());
        }
        this.setEnabled(list.isEnabled());
        this.setFont(list.getFont());
        Insets ins = SubstanceSizeUtils.getListCellRendererInsets(SubstanceSizeUtils.getComponentFontSize(list));
        this.setBorder(new EmptyBorder(ins.top, ins.left, ins.bottom, ins.right));
        this.setOpaque(false);
        return this;
    }

    @Override
    public final void paint(Graphics g) {
        super.paint(g);
    }

    @Override
    protected final void paintComponent(Graphics g) {
        super.paintComponent(g);
    }

    public static class SubstanceUIResource
    extends SubstanceDefaultListCellRenderer
    implements UIResource {
        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            return super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
        }
    }
}

