/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.code;

import java.io.PrintStream;
import sun.jvm.hotspot.code.ConstantDoubleValue;
import sun.jvm.hotspot.code.ConstantIntValue;
import sun.jvm.hotspot.code.ConstantLongValue;
import sun.jvm.hotspot.code.ConstantOopReadValue;
import sun.jvm.hotspot.code.DebugInfoReadStream;
import sun.jvm.hotspot.code.LocationValue;
import sun.jvm.hotspot.utilities.Assert;

public abstract class ScopeValue {
    static final int LOCATION_CODE = 0;
    static final int CONSTANT_INT_CODE = 1;
    static final int CONSTANT_OOP_CODE = 2;
    static final int CONSTANT_LONG_CODE = 3;
    static final int CONSTANT_DOUBLE_CODE = 4;
    static final int CONSTANT_OBJECT_CODE = 5;
    static final int CONSTANT_OBJECT_ID_CODE = 6;

    public boolean isLocation() {
        return false;
    }

    public boolean isConstantInt() {
        return false;
    }

    public boolean isConstantDouble() {
        return false;
    }

    public boolean isConstantLong() {
        return false;
    }

    public boolean isConstantOop() {
        return false;
    }

    public boolean isObject() {
        return false;
    }

    public static ScopeValue readFrom(DebugInfoReadStream stream) {
        switch (stream.readInt()) {
            case 0: {
                return new LocationValue(stream);
            }
            case 1: {
                return new ConstantIntValue(stream);
            }
            case 2: {
                return new ConstantOopReadValue(stream);
            }
            case 3: {
                return new ConstantLongValue(stream);
            }
            case 4: {
                return new ConstantDoubleValue(stream);
            }
            case 5: {
                return stream.readObjectValue();
            }
            case 6: {
                return stream.getCachedObject();
            }
        }
        Assert.that(false, "should not reach here");
        return null;
    }

    public abstract void printOn(PrintStream var1);
}

