/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.property;

import io.sf.carte.doc.color.Illuminant;
import io.sf.carte.doc.color.Illuminants;
import io.sf.carte.doc.color.RGBColorProfile;
import io.sf.jclf.math.linear3.Matrices;
import java.util.Arrays;

abstract class ColorProfile
implements RGBColorProfile {
    final double[][] m = new double[3][3];
    final double[][] minv = new double[3][3];

    protected ColorProfile(float xr, float yr, float xg, float yg, float xb, float yb, double[] white) {
        this.initialize(xr, yr, xg, yg, xb, yb, white);
    }

    void initialize(float xr, float yr, float xg, float yg, float xb, float yb, double[] white) {
        this.rgbToXYZmatrix(xr, yr, xg, yg, xb, yb, white);
        Matrices.inverse3((double[][])this.m, (double[][])this.minv);
    }

    void rgbToXYZmatrix(float xr, float yr, float xg, float yg, float xb, float yb, double[] white) {
        this.m[0][0] = xr / yr;
        this.m[1][0] = 1.0;
        this.m[2][0] = (1.0 - (double)xr - (double)yr) / (double)yr;
        this.m[0][1] = xg / yg;
        this.m[1][1] = 1.0;
        this.m[2][1] = (1.0 - (double)xg - (double)yg) / (double)yg;
        this.m[0][2] = xb / yb;
        this.m[1][2] = 1.0;
        this.m[2][2] = (1.0 - (double)xb - (double)yb) / (double)yb;
        double[][] minv = new double[3][3];
        Matrices.inverse3((double[][])this.m, (double[][])minv);
        double[] s = new double[3];
        Matrices.multiplyByVector3((double[][])minv, (double[])white, (double[])s);
        double[] dArray = this.m[0];
        dArray[0] = dArray[0] * s[0];
        double[] dArray2 = this.m[1];
        dArray2[0] = dArray2[0] * s[0];
        double[] dArray3 = this.m[2];
        dArray3[0] = dArray3[0] * s[0];
        double[] dArray4 = this.m[0];
        dArray4[1] = dArray4[1] * s[1];
        double[] dArray5 = this.m[1];
        dArray5[1] = dArray5[1] * s[1];
        double[] dArray6 = this.m[2];
        dArray6[1] = dArray6[1] * s[1];
        double[] dArray7 = this.m[0];
        dArray7[2] = dArray7[2] * s[2];
        double[] dArray8 = this.m[1];
        dArray8[2] = dArray8[2] * s[2];
        double[] dArray9 = this.m[2];
        dArray9[2] = dArray9[2] * s[2];
    }

    public void linearRgbToXYZ(double r, double g, double b, double[] xyz) {
        xyz[0] = this.m[0][0] * r + this.m[0][1] * g + this.m[0][2] * b;
        xyz[1] = this.m[1][0] * r + this.m[1][1] * g + this.m[1][2] * b;
        xyz[2] = this.m[2][0] * r + this.m[2][1] * g + this.m[2][2] * b;
    }

    @Override
    public void linearRgbToXYZ(double[] rgb, double[] xyz) {
        Matrices.multiplyByVector3((double[][])this.m, (double[])rgb, (double[])xyz);
    }

    @Override
    public void xyzToLinearRgb(double[] xyz, double[] linearRgb) {
        Matrices.multiplyByVector3((double[][])this.minv, (double[])xyz, (double[])linearRgb);
    }

    @Override
    public double gammaCompanding(double linearComponent) {
        double abs = Math.abs(linearComponent);
        double nlComp = abs <= 0.0031308 ? 12.92 * linearComponent : 1.055 * Math.signum(linearComponent) * Math.pow(abs, 0.4166666666666667) - 0.055;
        return nlComp;
    }

    @Override
    public double linearComponent(double compandedComponent) {
        double abs = Math.abs(compandedComponent);
        double linearComp = abs <= 0.04045 ? compandedComponent / 12.92 : Math.signum(compandedComponent) * Math.pow((abs + 0.055) / 1.055, 2.4);
        return linearComp;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Arrays.deepHashCode((Object[])this.m);
        result = 31 * result + Arrays.hashCode(this.getWhitePoint());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ColorProfile other = (ColorProfile)obj;
        return Arrays.deepEquals((Object[])this.m, (Object[])other.m) && Arrays.equals(this.getWhitePoint(), other.getWhitePoint());
    }

    public abstract Illuminant getIlluminant();

    @Override
    public double[] getWhitePoint() {
        return Illuminants.whiteD65;
    }
}

