﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/core/utils/memory/stl/AWSVector.h>
#include <aws/rekognition/Rekognition_EXPORTS.h>
#include <aws/rekognition/model/UnsuccessfulFaceAssociationReason.h>

#include <utility>

namespace Aws {
namespace Utils {
namespace Json {
class JsonValue;
class JsonView;
}  // namespace Json
}  // namespace Utils
namespace Rekognition {
namespace Model {

/**
 * <p>Contains metadata like FaceId, UserID, and Reasons, for a face that was
 * unsuccessfully associated.</p><p><h3>See Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/rekognition-2016-06-27/UnsuccessfulFaceAssociation">AWS
 * API Reference</a></p>
 */
class UnsuccessfulFaceAssociation {
 public:
  AWS_REKOGNITION_API UnsuccessfulFaceAssociation() = default;
  AWS_REKOGNITION_API UnsuccessfulFaceAssociation(Aws::Utils::Json::JsonView jsonValue);
  AWS_REKOGNITION_API UnsuccessfulFaceAssociation& operator=(Aws::Utils::Json::JsonView jsonValue);
  AWS_REKOGNITION_API Aws::Utils::Json::JsonValue Jsonize() const;

  ///@{
  /**
   * <p>A unique identifier assigned to the face. </p>
   */
  inline const Aws::String& GetFaceId() const { return m_faceId; }
  inline bool FaceIdHasBeenSet() const { return m_faceIdHasBeenSet; }
  template <typename FaceIdT = Aws::String>
  void SetFaceId(FaceIdT&& value) {
    m_faceIdHasBeenSet = true;
    m_faceId = std::forward<FaceIdT>(value);
  }
  template <typename FaceIdT = Aws::String>
  UnsuccessfulFaceAssociation& WithFaceId(FaceIdT&& value) {
    SetFaceId(std::forward<FaceIdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>A provided ID for the UserID. Unique within the collection. </p>
   */
  inline const Aws::String& GetUserId() const { return m_userId; }
  inline bool UserIdHasBeenSet() const { return m_userIdHasBeenSet; }
  template <typename UserIdT = Aws::String>
  void SetUserId(UserIdT&& value) {
    m_userIdHasBeenSet = true;
    m_userId = std::forward<UserIdT>(value);
  }
  template <typename UserIdT = Aws::String>
  UnsuccessfulFaceAssociation& WithUserId(UserIdT&& value) {
    SetUserId(std::forward<UserIdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>Match confidence with the UserID, provides information regarding if a face
   * association was unsuccessful because it didn't meet UserMatchThreshold.</p>
   */
  inline double GetConfidence() const { return m_confidence; }
  inline bool ConfidenceHasBeenSet() const { return m_confidenceHasBeenSet; }
  inline void SetConfidence(double value) {
    m_confidenceHasBeenSet = true;
    m_confidence = value;
  }
  inline UnsuccessfulFaceAssociation& WithConfidence(double value) {
    SetConfidence(value);
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p> The reason why the association was unsuccessful. </p>
   */
  inline const Aws::Vector<UnsuccessfulFaceAssociationReason>& GetReasons() const { return m_reasons; }
  inline bool ReasonsHasBeenSet() const { return m_reasonsHasBeenSet; }
  template <typename ReasonsT = Aws::Vector<UnsuccessfulFaceAssociationReason>>
  void SetReasons(ReasonsT&& value) {
    m_reasonsHasBeenSet = true;
    m_reasons = std::forward<ReasonsT>(value);
  }
  template <typename ReasonsT = Aws::Vector<UnsuccessfulFaceAssociationReason>>
  UnsuccessfulFaceAssociation& WithReasons(ReasonsT&& value) {
    SetReasons(std::forward<ReasonsT>(value));
    return *this;
  }
  inline UnsuccessfulFaceAssociation& AddReasons(UnsuccessfulFaceAssociationReason value) {
    m_reasonsHasBeenSet = true;
    m_reasons.push_back(value);
    return *this;
  }
  ///@}
 private:
  Aws::String m_faceId;
  bool m_faceIdHasBeenSet = false;

  Aws::String m_userId;
  bool m_userIdHasBeenSet = false;

  double m_confidence{0.0};
  bool m_confidenceHasBeenSet = false;

  Aws::Vector<UnsuccessfulFaceAssociationReason> m_reasons;
  bool m_reasonsHasBeenSet = false;
};

}  // namespace Model
}  // namespace Rekognition
}  // namespace Aws
