/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.cext.capi;

import com.oracle.graal.python.builtins.objects.cext.capi.CExtNodes;
import com.oracle.graal.python.builtins.objects.cext.capi.PythonNativeWrapper;
import com.oracle.graal.python.builtins.objects.cext.capi.transitions.CApiTransitions;
import com.oracle.graal.python.builtins.objects.ints.PInt;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.runtime.PythonContext;
import com.oracle.graal.python.util.OverflowException;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.InvalidArrayIndexException;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.library.ExportLibrary;
import com.oracle.truffle.api.library.ExportMessage;
import sun.misc.Unsafe;

@ExportLibrary(value=InteropLibrary.class)
public final class CPyObjectArrayWrapper
extends PythonNativeWrapper.PythonStructNativeWrapper {
    private static final Unsafe UNSAFE = PythonUtils.initUnsafe();
    private final Object[] wrappers;

    @CompilerDirectives.TruffleBoundary
    private static long allocateBoundary(long size) {
        return UNSAFE.allocateMemory(size);
    }

    @CompilerDirectives.TruffleBoundary
    private static void freeBoundary(long ptr) {
        UNSAFE.freeMemory(ptr);
    }

    public CPyObjectArrayWrapper(Object[] delegate) {
        super(delegate);
        this.wrappers = new Object[delegate.length];
    }

    public Object[] getObjectArray() {
        return (Object[])this.getDelegate();
    }

    @ExportMessage
    boolean isPointer() {
        return this.isNative();
    }

    @ExportMessage
    long asPointer() {
        return this.getNativePointer();
    }

    @ExportMessage
    long getArraySize() {
        return this.wrappers.length;
    }

    @ExportMessage
    boolean hasArrayElements() {
        return true;
    }

    @ExportMessage
    Object readArrayElement(long index, @Cached.Shared(value="toNativeNode") @Cached CApiTransitions.PythonToNativeNode toNativeNode) throws InvalidArrayIndexException {
        try {
            int idx = PInt.intValueExact(index);
            if (idx >= 0 && idx < this.wrappers.length) {
                if (this.wrappers[idx] == null) {
                    Object[] arr = this.getObjectArray();
                    this.wrappers[idx] = toNativeNode.execute(arr[idx]);
                }
                return this.wrappers[idx];
            }
        }
        catch (OverflowException overflowException) {
            // empty catch block
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        throw InvalidArrayIndexException.create((long)index);
    }

    @ExportMessage
    boolean isArrayElementReadable(long identifier) {
        return 0L <= identifier && identifier < (long)this.wrappers.length;
    }

    @ExportMessage
    void toNative(@Cached.Shared(value="toNativeNode") @Cached CApiTransitions.PythonToNativeNode toNativeNode, @CachedLibrary(limit="3") InteropLibrary interopLib) {
        if (!PythonContext.get(toNativeNode).isNativeAccessAllowed()) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            throw new RuntimeException(ErrorMessages.NATIVE_ACCESS_NOT_ALLOWED.toJavaStringUncached());
        }
        if (!this.isNative()) {
            Object[] data = this.getObjectArray();
            long ptr = CPyObjectArrayWrapper.allocateBoundary((long)this.wrappers.length * 8L);
            try {
                for (int i = 0; i < data.length; ++i) {
                    if (this.wrappers[i] == null) {
                        this.wrappers[i] = toNativeNode.execute(data[i]);
                    }
                    interopLib.toNative(this.wrappers[i]);
                    UNSAFE.putLong(ptr + (long)i * 8L, interopLib.asPointer(this.wrappers[i]));
                }
            }
            catch (UnsupportedMessageException e) {
                throw CompilerDirectives.shouldNotReachHere();
            }
            this.setNativePointer(ptr);
        }
    }

    public void free(CExtNodes.ReleaseNativeWrapperNode releaseNativeWrapperNode) {
        if (this.isNative()) {
            if (!PythonContext.get(releaseNativeWrapperNode).isNativeAccessAllowed()) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                throw new RuntimeException(ErrorMessages.NATIVE_ACCESS_NOT_ALLOWED.toJavaStringUncached());
            }
            CPyObjectArrayWrapper.freeBoundary(this.getNativePointer());
        }
    }
}

