/* Copyright (c) 2000, 2011, Oracle and/or its affiliates. All rights reserved.
   Copyright (c) 2017, MariaDB Corporation.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; version 2 of the License.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1335  USA */


#ifndef _typelib_h
#define _typelib_h

#include "my_alloc.h"

typedef struct st_typelib {	/* Different types saved here */
  unsigned int count;		/* How many types */
  const char *name;		/* Name of typelib */
  const char **type_names;
  unsigned int *type_lengths;
  /*
    An array of indexes of enum values that are no longer supported and so are
    hidden. One cannot specify hidden values, an attempt to do so will produce
    a warning (while an attempt to use a name that was never part of this set
    will produce an error).
  */
  const int *hidden_values;
} TYPELIB;

#define CREATE_TYPELIB_FOR(X) { (unsigned int)(sizeof(X)/sizeof(X[0])) - 1, "", X, NULL, NULL }

extern my_ulonglong find_typeset(const char *x, TYPELIB *typelib,
                                 int *error_position);
extern int find_type_with_warning(const char *x, TYPELIB *typelib,
                                  const char *option);
#define FIND_TYPE_BASIC           0
/** makes @c find_type() require the whole name, no prefix */
#define FIND_TYPE_NO_PREFIX      (1U << 0)
/** always implicitly on, so unused, but old code may pass it */
#define FIND_TYPE_NO_OVERWRITE   0
/** makes @c find_type() accept a number. Not used either */
#define FIND_TYPE_ALLOW_NUMBER   0
/** makes @c find_type() treat ',' and '=' as terminators */
#define FIND_TYPE_COMMA_TERM     (1U << 3)

extern int find_type(const char *x, const TYPELIB *typelib, unsigned int flags);
extern void make_type(char *to,unsigned int nr,TYPELIB *typelib);
extern const char *get_type(TYPELIB *typelib,unsigned int nr);
extern TYPELIB *copy_typelib(MEM_ROOT *root, const TYPELIB *from);

extern TYPELIB sql_protocol_typelib;

my_ulonglong find_set_from_flags(const TYPELIB *lib, unsigned int default_name,
                              my_ulonglong cur_set, my_ulonglong default_set,
                              const char *str, unsigned int length,
                              char **err_pos, unsigned int *err_len);

#endif /* _typelib_h */
