/*! @azure/msal-browser v4.26.1 2025-11-06 */
'use strict';
import { AuthFlowStateBase } from '../../../core/auth_flow/AuthFlowState.mjs';
import { SIGN_IN_FAILED_STATE_TYPE } from '../../../core/auth_flow/AuthFlowStateTypes.mjs';

/*
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License.
 */
/**
 * Represents the state of a sign-in operation that has been failed.
 */
class SignInFailedState extends AuthFlowStateBase {
    constructor() {
        super(...arguments);
        /**
         * The type of the state.
         */
        this.stateType = SIGN_IN_FAILED_STATE_TYPE;
    }
}

export { SignInFailedState };
//# sourceMappingURL=SignInFailedState.mjs.map
