﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/arc-region-switch/ARCRegionswitch_EXPORTS.h>
#include <aws/core/utils/memory/stl/AWSString.h>

namespace Aws {
namespace ARCRegionswitch {
namespace Model {
enum class GlobalAuroraDefaultBehavior { NOT_SET, switchoverOnly, failover };

namespace GlobalAuroraDefaultBehaviorMapper {
AWS_ARCREGIONSWITCH_API GlobalAuroraDefaultBehavior GetGlobalAuroraDefaultBehaviorForName(const Aws::String& name);

AWS_ARCREGIONSWITCH_API Aws::String GetNameForGlobalAuroraDefaultBehavior(GlobalAuroraDefaultBehavior value);
}  // namespace GlobalAuroraDefaultBehaviorMapper
}  // namespace Model
}  // namespace ARCRegionswitch
}  // namespace Aws
